/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.core;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.CharArraySet;
import guideme.internal.shaded.lucene.analysis.LowerCaseFilter;
import guideme.internal.shaded.lucene.analysis.StopFilter;
import guideme.internal.shaded.lucene.analysis.StopwordAnalyzerBase;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.core.LetterTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;

public final class StopAnalyzer
extends StopwordAnalyzerBase {
    public StopAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public StopAnalyzer(Path stopwordsFile) throws IOException {
        this(StopAnalyzer.loadStopwordSet(stopwordsFile));
    }

    public StopAnalyzer(Reader stopwords) throws IOException {
        this(StopAnalyzer.loadStopwordSet(stopwords));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        LetterTokenizer source = new LetterTokenizer();
        return new Analyzer.TokenStreamComponents(source, (TokenStream)new StopFilter(new LowerCaseFilter(source), this.stopwords));
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }
}

