/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.search;

import guideme.internal.search.IndexSchema;
import guideme.internal.search.QueryStringSplitter;
import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BooleanQuery;
import guideme.internal.shaded.lucene.search.BoostQuery;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.WildcardQuery;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.QueryBuilder;
import java.util.Collection;
import java.util.List;

public class GuideQueryParser {
    private GuideQueryParser() {
    }

    public static Query parse(String queryString, Analyzer analyzer, Collection<String> searchLanguages) {
        List<String> tokens = QueryStringSplitter.split(queryString);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        QueryBuilder queryBuilder = new QueryBuilder(analyzer);
        for (String searchLanguage : searchLanguages) {
            String textField = IndexSchema.getTextField(searchLanguage);
            String titleField = IndexSchema.getTitleField(searchLanguage);
            builder.add(new BoostQuery(GuideQueryParser.buildFieldQuery(queryBuilder, titleField, tokens, false, BooleanClause.Occur.SHOULD), 1.2f), BooleanClause.Occur.SHOULD);
            builder.add(GuideQueryParser.buildFieldQuery(queryBuilder, textField, tokens, false, BooleanClause.Occur.SHOULD), BooleanClause.Occur.SHOULD);
            builder.add(new BoostQuery(GuideQueryParser.buildFieldQuery(queryBuilder, titleField, tokens, true, BooleanClause.Occur.SHOULD), 0.4f), BooleanClause.Occur.SHOULD);
            builder.add(new BoostQuery(GuideQueryParser.buildFieldQuery(queryBuilder, textField, tokens, true, BooleanClause.Occur.SHOULD), 0.2f), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    private static BooleanQuery buildFieldQuery(QueryBuilder queryBuilder, String fieldName, List<String> tokens, boolean makeLastTokenWildcard, BooleanClause.Occur clause) {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        for (int i = 0; i < tokens.size(); ++i) {
            Query q;
            Object token = tokens.get(i);
            if (((String)token).contains(" ")) {
                booleanQueryBuilder.add(queryBuilder.createPhraseQuery(fieldName, (String)token), clause);
                continue;
            }
            if (makeLastTokenWildcard && i == tokens.size() - 1 && !((String)token).endsWith("*")) {
                token = (String)token + "*";
            }
            if (((String)token).contains("*")) {
                BytesRef normalizedTerm = queryBuilder.getAnalyzer().normalize(fieldName, (String)token);
                q = new WildcardQuery(new Term(fieldName, normalizedTerm));
            } else {
                q = queryBuilder.createBooleanQuery(fieldName, (String)token);
            }
            booleanQueryBuilder.add(q, clause);
        }
        return booleanQueryBuilder.build();
    }
}

