/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.flow;

import guideme.PageAnchor;
import guideme.color.SymbolicColor;
import guideme.document.flow.LytTooltipSpan;
import guideme.internal.GuideMEClient;
import guideme.ui.GuideUiHost;
import java.net.URI;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;

public class LytFlowLink
extends LytTooltipSpan {
    @Nullable
    private Consumer<GuideUiHost> clickCallback;
    @Nullable
    private SoundEvent clickSound = GuideMEClient.GUIDE_CLICK_EVENT;

    public LytFlowLink() {
        this.modifyStyle(style -> style.color(SymbolicColor.LINK));
        this.modifyHoverStyle(style -> style.underlined(true));
    }

    public void setClickCallback(@Nullable Consumer<GuideUiHost> clickCallback) {
        this.clickCallback = clickCallback;
    }

    @Override
    public boolean mouseClicked(GuideUiHost screen, int x, int y, int button) {
        if (button == 0 && this.clickCallback != null) {
            if (this.clickSound != null) {
                SoundManager handler = Minecraft.m_91087_().m_91106_();
                handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.clickSound, (float)1.0f));
            }
            this.clickCallback.accept(screen);
            return true;
        }
        return false;
    }

    @Nullable
    public SoundEvent getClickSound() {
        return this.clickSound;
    }

    public void setClickSound(@Nullable SoundEvent clickSound) {
        this.clickSound = clickSound;
    }

    public void setExternalUrl(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("External URLs must be absolute: " + uri);
        }
        this.setClickCallback(screen -> {
            Minecraft mc = Minecraft.m_91087_();
            Screen previousScreen = mc.f_91080_;
            mc.m_91152_((Screen)new ConfirmLinkScreen(yes -> {
                if (yes) {
                    Util.m_137581_().m_137648_(uri);
                }
                mc.m_91152_(previousScreen);
            }, uri.toString(), true));
        });
    }

    public void setPageLink(PageAnchor anchor) {
        this.setClickCallback(screen -> screen.navigateTo(anchor));
    }
}

