/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.util;

import java.util.Locale;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.lang.LangNumberFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class Lang {
    public static MutableComponent translateDirect(String key, Object ... args) {
        return Component.m_237110_((String)("ratatouille." + key), (Object[])Lang.resolveBuilders(args));
    }

    public static String asId(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public static String nonPluralId(String name) {
        String asId = Lang.asId(name);
        return asId.endsWith("s") ? asId.substring(0, asId.length() - 1) : asId;
    }

    public static LangBuilder builder() {
        return new LangBuilder("ratatouille");
    }

    public static LangBuilder builder(String namespace) {
        return new LangBuilder(namespace);
    }

    public static LangBuilder blockName(BlockState state) {
        return Lang.builder().add(state.m_60734_().m_49954_());
    }

    public static LangBuilder itemName(ItemStack stack) {
        return Lang.builder().add(stack.m_41786_().m_6881_());
    }

    public static LangBuilder fluidName(FluidStack stack) {
        return Lang.builder().add(stack.getDisplayName().m_6881_());
    }

    public static LangBuilder number(double d) {
        return Lang.builder().text(LangNumberFormat.format((double)d));
    }

    public static LangBuilder translate(String langKey, Object ... args) {
        return Lang.builder().translate(langKey, args);
    }

    public static LangBuilder text(String text) {
        return Lang.builder().text(text);
    }

    public static Object[] resolveBuilders(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (!(object instanceof LangBuilder)) continue;
            LangBuilder cb = (LangBuilder)object;
            args[i] = cb.component();
        }
        return args;
    }
}

