/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.data.recipe;

import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.forsteri.ratatouille.data.recipe.BakingRecipeGen;
import org.forsteri.ratatouille.data.recipe.CompostingRecipeGen;
import org.forsteri.ratatouille.data.recipe.DemoldingRecipeGen;
import org.forsteri.ratatouille.data.recipe.FreezingRecipeGen;
import org.forsteri.ratatouille.data.recipe.RataouilleRecipeProvider;
import org.forsteri.ratatouille.data.recipe.SqueezingRecipeGen;
import org.forsteri.ratatouille.data.recipe.ThreshingRecipeGen;

public abstract class ProcessingRecipeGen
extends RataouilleRecipeProvider {
    protected static final List<ProcessingRecipeGen> GENERATORS = new ArrayList<ProcessingRecipeGen>();
    protected static final int BUCKET = 1000;
    protected static final int BOTTLE = 250;

    public ProcessingRecipeGen(PackOutput generator) {
        super(generator);
    }

    public static void registerAll(DataGenerator gen, PackOutput output) {
        GENERATORS.add(new ThreshingRecipeGen(output));
        GENERATORS.add(new SqueezingRecipeGen(output));
        GENERATORS.add(new DemoldingRecipeGen(output));
        GENERATORS.add(new FreezingRecipeGen(output));
        GENERATORS.add(new CompostingRecipeGen(output));
        GENERATORS.add(new BakingRecipeGen(output));
        gen.addProvider(true, new DataProvider(){

            public CompletableFuture<?> m_213708_(CachedOutput dc) {
                return CompletableFuture.allOf((CompletableFuture[])GENERATORS.stream().map(gen -> gen.m_213708_(dc)).toArray(CompletableFuture[]::new));
            }

            public String m_6055_() {
                return "Ratatouille's Processing Recipes";
            }
        });
    }

    <T extends ProcessingRecipe<?>> RataouilleRecipeProvider.GeneratedRecipe create(Supplier<ItemLike> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.create("ratatouille", singleIngredient, transform);
    }

    protected <T extends ProcessingRecipe<?>> RataouilleRecipeProvider.GeneratedRecipe create(String namespace, Supplier<ItemLike> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        RataouilleRecipeProvider.GeneratedRecipe generatedRecipe = c -> {
            ItemLike itemLike = (ItemLike)singleIngredient.get();
            ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), new ResourceLocation(namespace, CatnipServices.REGISTRIES.getKeyOrThrow(itemLike.m_5456_()).m_135815_())).withItemIngredients(new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike})}))).build(c);
        };
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    protected <T extends ProcessingRecipe<?>> ProcessingRecipeSerializer<T> getSerializer() {
        return (ProcessingRecipeSerializer)this.getRecipeType().getSerializer();
    }

    protected abstract IRecipeTypeInfo getRecipeType();

    <T extends ProcessingRecipe<?>> RataouilleRecipeProvider.GeneratedRecipe create(String name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.create(new ResourceLocation("ratatouille", name), transform);
    }

    protected <T extends ProcessingRecipe<?>> RataouilleRecipeProvider.GeneratedRecipe create(ResourceLocation name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.createWithDeferredId(() -> name, transform);
    }

    protected <T extends ProcessingRecipe<?>> RataouilleRecipeProvider.GeneratedRecipe createWithDeferredId(Supplier<ResourceLocation> name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        RataouilleRecipeProvider.GeneratedRecipe generatedRecipe = c -> ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), (ResourceLocation)name.get()))).build(c);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    protected Supplier<ResourceLocation> idWithSuffix(Supplier<ItemLike> item, String suffix) {
        return () -> {
            ResourceLocation registryName = CatnipServices.REGISTRIES.getKeyOrThrow(((ItemLike)item.get()).m_5456_());
            String var10000 = registryName.m_135815_();
            return new ResourceLocation("ratatouille", var10000 + suffix);
        };
    }
}

