/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.squeeze_basin;

import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.forsteri.ratatouille.content.squeeze_basin.SqueezeBasinBlockEntity;
import org.forsteri.ratatouille.entry.CRItems;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.jetbrains.annotations.NotNull;

public class SqueezingRecipe
extends ProcessingRecipe<SmartInventory> {
    public SqueezingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)CRRecipeTypes.SQUEEZING, params);
    }

    protected int getMaxInputCount() {
        return 2;
    }

    protected int getMaxFluidInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    public boolean matches(@NotNull SmartInventory smartInventory, @NotNull Level level) {
        boolean useCasing = false;
        for (Ingredient ingredient : this.ingredients) {
            if (ingredient.test(CRItems.SAUSAGE_CASING.asStack())) {
                useCasing = true;
                continue;
            }
            if (!ingredient.test(smartInventory.m_8020_(0))) continue;
            return true;
        }
        return useCasing;
    }

    public boolean useCasing() {
        for (Ingredient ingredient : this.ingredients) {
            if (!ingredient.test(CRItems.SAUSAGE_CASING.asStack())) continue;
            return true;
        }
        return false;
    }

    public boolean match(@NotNull SqueezeBasinBlockEntity be, boolean hasCasing) {
        if (be.getOperator().isEmpty()) {
            return false;
        }
        IFluidHandler inputTank = (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (be.inputInventory == null || inputTank == null) {
            return false;
        }
        boolean useCasing = this.useCasing();
        if (useCasing != hasCasing) {
            return false;
        }
        if (useCasing && this.ingredients.size() == 1) {
            if (this.fluidIngredients.isEmpty()) {
                return true;
            }
            return ((FluidIngredient)this.fluidIngredients.get(0)).test(inputTank.getFluidInTank(0));
        }
        for (Ingredient ingredient : this.ingredients) {
            if (!ingredient.test(be.inputInventory.m_8020_(0))) continue;
            if (this.fluidIngredients.isEmpty()) {
                return true;
            }
            return ((FluidIngredient)this.fluidIngredients.get(0)).test(inputTank.getFluidInTank(0));
        }
        return false;
    }
}

