/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.demolder;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.forsteri.ratatouille.content.demolder.DemoldingRecipe;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.forsteri.ratatouille.entry.CRTags;

public class MechanicalDemolderBlockEntity
extends KineticBlockEntity
implements PressingBehaviour.PressingBehaviourSpecifics {
    public ItemStackHandler outputInv = new ItemStackHandler(1);
    public LazyOptional<IItemHandler> capability = LazyOptional.of(() -> new DemolderInventoryHandler());
    public PressingBehaviour demoldingBehaviour;
    private static final RecipeWrapper demoldingInv = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

    public MechanicalDemolderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82363_(0.0, -1.5, 0.0).m_82363_(0.0, 1.0, 0.0);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.demoldingBehaviour = new PressingBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.demoldingBehaviour);
    }

    public PressingBehaviour getPressingBehaviour() {
        return this.demoldingBehaviour;
    }

    public Optional<DemoldingRecipe> getRecipe(ItemStack item) {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)item, CRRecipeTypes.DEMOLDING.getType(), DemoldingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        demoldingInv.m_6836_(0, item);
        return CRRecipeTypes.DEMOLDING.find(demoldingInv, this.f_58857_);
    }

    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).m_41613_() != this.outputInv.getSlotLimit(i)) continue;
            return false;
        }
        Optional<DemoldingRecipe> recipe = this.getRecipe(input.stack);
        if (!recipe.isPresent()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.demoldingBehaviour.particleItems.add(input.stack);
        List outputs = RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)(this.canProcessInBulk() ? input.stack : ItemHandlerHelper.copyStackWithSize((ItemStack)input.stack, (int)1)), (Recipe)((Recipe)recipe.get()));
        for (ItemStack itemStack : outputs) {
            if (!itemStack.m_204117_(CRTags.MOLD)) {
                outputList.add(itemStack);
                continue;
            }
            if (this.outputInv.insertItem(0, itemStack.m_41777_(), true).m_41619_()) {
                this.outputInv.insertItem(0, itemStack.m_41777_(), false);
                return true;
            }
            return false;
        }
        return true;
    }

    public void invalidate() {
        super.invalidate();
        this.capability.invalidate();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.outputInv);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("OutputInventory", (Tag)this.outputInv.serializeNBT());
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.outputInv.deserializeNBT(compound.m_128469_("OutputInventory"));
        super.read(compound, clientPacket);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public int getParticleAmount() {
        return 15;
    }

    public float getKineticSpeed() {
        return this.getSpeed();
    }

    public void onPressingCompleted() {
    }

    public boolean tryProcessInBasin(boolean simulate) {
        return false;
    }

    public boolean tryProcessInWorld(ItemEntity itemEntity, boolean simulate) {
        return false;
    }

    public boolean canProcessInBulk() {
        return false;
    }

    public float calculateStressApplied() {
        return 8.0f;
    }

    private class DemolderInventoryHandler
    extends CombinedInvWrapper {
        public DemolderInventoryHandler() {
            super(new IItemHandlerModifiable[]{MechanicalDemolderBlockEntity.this.outputInv});
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }
    }
}

