/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.compost_tower;

import com.simibubi.create.content.fluids.tank.BoilerHeaters;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.List;
import java.util.Optional;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.forsteri.ratatouille.content.compost_tower.CompostFluidTank;
import org.forsteri.ratatouille.content.compost_tower.CompostItemHandler;
import org.forsteri.ratatouille.content.compost_tower.CompostTowerBlockEntity;
import org.forsteri.ratatouille.content.compost_tower.CompostingRecipe;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.forsteri.ratatouille.util.Lang;
import org.jetbrains.annotations.NotNull;

public class CompostData {
    public int sizeLevel;
    public int tempLevel;
    public int updateRequired;
    public int timer;
    public CompostingRecipe lastRecipe;

    public void clear() {
        this.sizeLevel = 0;
        this.tempLevel = 0;
        this.timer = 0;
        this.lastRecipe = null;
    }

    public boolean updateCompostTower(CompostTowerBlockEntity controller) {
        assert (controller.m_58904_() != null);
        BlockPos controllerPos = controller.m_58899_();
        Level level = controller.m_58904_();
        --this.updateRequired;
        int prevTemp = this.tempLevel;
        this.tempLevel = 0;
        for (int xOffset = 0; xOffset < controller.getWidth(); ++xOffset) {
            for (int zOffset = 0; zOffset < controller.getWidth(); ++zOffset) {
                float heat;
                BlockPos pos = controllerPos.m_7918_(xOffset, -1, zOffset);
                BlockState blockState = level.m_8055_(pos);
                if (!(blockState.m_60734_() instanceof BlazeBurnerBlock) && !blockState.m_61138_((Property)BlazeBurnerBlock.HEAT_LEVEL) || !((heat = (float)BoilerHeaters.blazeBurner((Level)level, (BlockPos)pos, (BlockState)blockState)) > 0.0f)) continue;
                this.tempLevel = (int)((float)this.tempLevel + heat);
            }
        }
        this.tempLevel = Mth.m_14045_((int)this.tempLevel, (int)0, (int)8);
        return this.tempLevel != prevTemp;
    }

    public void tick(CompostTowerBlockEntity tower) {
        if (this.updateCompostTower(tower)) {
            tower.notifyUpdate();
        }
        assert (tower.m_58904_() != null);
        CompostItemHandler itemHandler = tower.getItemInventory();
        CompostFluidTank fluidHandler = tower.tankInventory;
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)itemHandler);
        if (this.timer > 0) {
            if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, tower.m_58904_())) {
                Optional recipe = CRRecipeTypes.COMPOSTING.find(inventoryIn, tower.m_58904_());
                if (recipe.isEmpty()) {
                    return;
                }
                this.lastRecipe = (CompostingRecipe)((Object)recipe.get());
            }
            boolean canOutput = true;
            for (ItemStack outputStack : this.lastRecipe.rollResults()) {
                if (outputStack.m_41619_() || ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)outputStack, (boolean)true).m_41619_()) continue;
                canOutput = false;
                break;
            }
            for (FluidStack fluidStack2 : this.lastRecipe.getFluidResults()) {
                if (fluidStack2.isEmpty() || fluidHandler.fill(fluidStack2, IFluidHandler.FluidAction.SIMULATE) >= fluidStack2.getAmount()) continue;
                canOutput = false;
                break;
            }
            if (!canOutput) {
                this.timer = 100;
                return;
            }
            this.timer -= this.getProcessingSpeed();
            if (tower.m_58904_().f_46443_) {
                return;
            }
            if (this.timer <= 0) {
                itemHandler.consume(((Ingredient)this.lastRecipe.m_7527_().get(0)).m_43908_()[0], false);
                this.lastRecipe.rollResults().forEach(stack -> ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false));
                this.lastRecipe.getFluidResults().forEach(fluidStack -> fluidHandler.fill((FluidStack)fluidStack, IFluidHandler.FluidAction.EXECUTE));
                tower.notifyUpdate();
            }
            return;
        }
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, tower.m_58904_())) {
            Optional recipe = CRRecipeTypes.COMPOSTING.find(inventoryIn, tower.m_58904_());
            if (recipe.isEmpty()) {
                this.timer = 100;
            } else {
                this.lastRecipe = (CompostingRecipe)((Object)recipe.get());
                this.timer = this.lastRecipe.getProcessingDuration();
            }
        } else {
            this.timer = this.lastRecipe.getProcessingDuration();
        }
        tower.notifyUpdate();
    }

    public boolean evaluate(CompostTowerBlockEntity tower) {
        assert (tower.m_58904_() != null);
        int sizeLevelBefore = this.sizeLevel;
        this.sizeLevel = tower.getWidth() * tower.getHeight() * tower.getWidth() / 4;
        this.sizeLevel = Mth.m_14045_((int)this.sizeLevel, (int)0, (int)8);
        return sizeLevelBefore != this.sizeLevel;
    }

    public void read(CompoundTag compound, boolean ignoredClientPacket) {
        this.sizeLevel = compound.m_128451_("sizeCount");
        this.tempLevel = compound.m_128451_("tempCount");
    }

    public void write(CompoundTag compound, boolean ignoredClientPacket) {
        compound.m_128405_("sizeCount", this.sizeLevel);
        compound.m_128405_("tempCount", this.tempLevel);
    }

    public MutableComponent getSizeComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("size", this.sizeLevel, forGoggles, useBlocksAsBars, styles);
    }

    public MutableComponent getHeatComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("heat", this.tempLevel, forGoggles, useBlocksAsBars, styles);
    }

    private MutableComponent componentHelper(String label, int level, boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        MutableComponent base;
        MutableComponent mutableComponent = base = useBlocksAsBars ? this.blockComponent(level) : this.barComponent(level);
        if (!forGoggles) {
            return base;
        }
        ChatFormatting style1 = styles.length >= 1 ? styles[0] : ChatFormatting.GRAY;
        ChatFormatting style2 = styles.length >= 2 ? styles[1] : ChatFormatting.DARK_GRAY;
        return Lang.translateDirect("compost_tower." + label, new Object[0]).m_130940_(style1).m_7220_((Component)Lang.translateDirect("compost_tower." + label + "_dots", new Object[0]).m_130940_(style2)).m_7220_((Component)base);
    }

    private MutableComponent blockComponent(int level) {
        int clamped = Mth.m_14045_((int)level, (int)0, (int)8);
        return Component.m_237113_((String)("\u2588".repeat(clamped) + "\u2591".repeat(8 - clamped)));
    }

    private MutableComponent barComponent(int level) {
        return Component.m_237119_().m_7220_((Component)this.bars(Math.max(0, -1), ChatFormatting.DARK_GREEN)).m_7220_((Component)this.bars(0, ChatFormatting.GREEN)).m_7220_((Component)this.bars(Math.max(0, level - 0), ChatFormatting.DARK_GREEN)).m_7220_((Component)this.bars(Math.max(0, 8 - level), ChatFormatting.DARK_RED)).m_7220_((Component)this.bars(Math.max(0, Math.min(10, 2)), ChatFormatting.DARK_GRAY));
    }

    private MutableComponent bars(int level, ChatFormatting format) {
        return Component.m_237113_((String)Strings.repeat((char)'|', (int)level)).m_130940_(format);
    }

    @NotNull
    public MutableComponent getLevelComponent() {
        int compostTowerLevel = Math.min(this.sizeLevel, this.tempLevel);
        if (compostTowerLevel == 0) {
            return Lang.translateDirect("compost_tower.idle", new Object[0]);
        }
        return compostTowerLevel >= 8 ? Lang.translateDirect("compost_tower.max_lvl", new Object[0]) : Lang.translateDirect("compost_tower.lvl", new Object[0]).m_130946_(String.valueOf(compostTowerLevel));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean ignoredIsPlayerSneaking) {
        MutableComponent indent = Component.m_237113_((String)"    ");
        MutableComponent indent2 = Component.m_237113_((String)"     ");
        tooltip.add((Component)indent.m_6881_().m_7220_((Component)Lang.translateDirect("compost_tower.status", new Object[0]).m_7220_((Component)this.getLevelComponent().m_130940_(ChatFormatting.GREEN))));
        tooltip.add((Component)indent2.m_6881_().m_7220_((Component)this.getSizeComponent(true, false, new ChatFormatting[0])));
        tooltip.add((Component)indent2.m_6881_().m_7220_((Component)this.getHeatComponent(true, false, new ChatFormatting[0])));
        return true;
    }

    public int getProcessingSpeed() {
        if (Math.min(this.sizeLevel, this.tempLevel) == 0) {
            return 16;
        }
        return (int)((double)this.sizeLevel / 8.0 * (double)this.tempLevel / 8.0 * 512.0);
    }
}

