/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.forsteri.ratatouille.data.recipe.RatatouilleDataGen;
import org.forsteri.ratatouille.entry.CRBlockEntityTypes;
import org.forsteri.ratatouille.entry.CRBlocks;
import org.forsteri.ratatouille.entry.CRConfigs;
import org.forsteri.ratatouille.entry.CRCreativeModeTabs;
import org.forsteri.ratatouille.entry.CRFluids;
import org.forsteri.ratatouille.entry.CRItems;
import org.forsteri.ratatouille.entry.CRPartialModels;
import org.forsteri.ratatouille.entry.CRParticleTypes;
import org.forsteri.ratatouille.entry.CRPonderPlugin;
import org.forsteri.ratatouille.entry.CRRecipeTypes;
import org.forsteri.ratatouille.entry.CRSpriteShifts;
import org.forsteri.ratatouille.entry.CRTags;

@Mod(value="ratatouille")
public class Ratatouille {
    public static final String MOD_ID = "ratatouille";
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"ratatouille").setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));

    public Ratatouille() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRATE.registerEventListeners(modEventBus);
        CRPartialModels.register();
        CRSpriteShifts.register();
        CRBlocks.register();
        CRItems.register();
        CRFluids.register();
        CRBlockEntityTypes.register();
        CRTags.register();
        CRCreativeModeTabs.register(modEventBus);
        CRRecipeTypes.register(modEventBus);
        CRParticleTypes.register(modEventBus);
        CRConfigs.register(modLoadingContext);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(CRParticleTypes::registerFactories));
        modEventBus.addListener(EventPriority.LOWEST, RatatouilleDataGen::gatherData);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        PonderIndex.addPlugin((PonderPlugin)new CRPonderPlugin());
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="ratatouille", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
    }
}

