/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import rbasamoyai.escalated.advancements.WalkwayTravelTracker;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayHelper;
import rbasamoyai.escalated.walkways.WalkwayMovementHandler;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class WalkwayBlockEntity
extends KineticBlockEntity {
    public Map<Entity, WalkwayMovementHandler.TransportedEntityInfo> passengers;
    public int walkwayLength;
    public int walkwayWidth = 1;
    protected BlockPos controller;
    protected BlockPos widthReferencePos = this.m_58899_();
    public float visualProgress = 0.0f;
    protected int updateCount = 0;
    private DyeColor color = null;
    public boolean resetClientRender;
    public boolean lazyResetClientRender;

    public WalkwayBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(3);
    }

    public void tick() {
        if (this.walkwayLength == 0) {
            WalkwayBlock.initWalkway(this.f_58857_, this.f_58858_);
        }
        if (this.f_58857_.f_46443_ && this.lazyResetClientRender) {
            this.lazyResetClientRender = false;
            this.resetClientRender = true;
        }
        super.tick();
        if (!(this.f_58857_.m_8055_(this.f_58858_).m_60734_() instanceof WalkwayBlock)) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        if (this.updateCount <= 0) {
            this.visualProgress += this.getWalkwayMovementSpeed();
            if (Math.abs(this.visualProgress) > 0.5f) {
                this.visualProgress = Math.signum(this.visualProgress) * (Math.abs(this.visualProgress) % 0.5f);
            }
            this.updateNeighbors();
        } else {
            this.updateCount = Math.max(0, this.updateCount - 1);
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.f_58857_.m_46467_() % 40L == 0L) {
            this.sendData();
        }
        if (this.passengers == null) {
            this.passengers = new HashMap<Entity, WalkwayMovementHandler.TransportedEntityInfo>();
        }
        Iterator<Map.Entry<Entity, WalkwayMovementHandler.TransportedEntityInfo>> iter = this.passengers.entrySet().iterator();
        while (iter.hasNext()) {
            WalkwaySlope slope;
            Map.Entry<Entity, WalkwayMovementHandler.TransportedEntityInfo> entry = iter.next();
            Entity entity = entry.getKey();
            WalkwayMovementHandler.TransportedEntityInfo info = entry.getValue();
            boolean canBeTransported = WalkwayMovementHandler.canBeTransported(entity);
            boolean leftTheBelt = info.getTicksSinceLastCollision() > 3;
            BlockPos lastCollidedPos = info.lastCollidedPos;
            BlockState lastCollidedState = info.lastCollidedState;
            Block block = lastCollidedState.m_60734_();
            if (block instanceof WalkwayBlock) {
                WalkwayBlock other = (WalkwayBlock)block;
                v0 = other.getWalkwaySlope(lastCollidedState);
            } else {
                v0 = slope = WalkwaySlope.TERMINAL;
            }
            if (leftTheBelt && slope != WalkwaySlope.TERMINAL && slope != WalkwaySlope.HORIZONTAL && this.f_58857_.m_7702_(lastCollidedPos) instanceof WalkwayBlockEntity && entity.m_20191_().m_82381_(new AABB(lastCollidedPos).m_82377_(0.0, 0.5, 0.0))) {
                info.refresh(lastCollidedPos, info.lastCollidedState);
                leftTheBelt = false;
            }
            if (!canBeTransported || leftTheBelt) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!this.f_58857_.f_46443_) {
                        WalkwayTravelTracker.stopTrackingPlayerOnWalkway(player);
                    }
                }
                iter.remove();
                continue;
            }
            info.tick();
            WalkwayMovementHandler.transportEntity(this, entity, info);
        }
    }

    public void attachKinetics() {
        if (this.f_58859_) {
            return;
        }
        super.attachKinetics();
    }

    public void updateNeighbors() {
        int actualWidth;
        WalkwayBlock currentWalkway = null;
        BlockState thisState = this.m_58900_();
        Block block = thisState.m_60734_();
        if (!(block instanceof WalkwayBlock)) {
            return;
        }
        WalkwayBlock walkwayBlock = (WalkwayBlock)block;
        BlockPos pos = this.m_58899_();
        BlockPos referencePos = this.widthReferencePos;
        Direction facing = walkwayBlock.getFacing(thisState);
        Direction left = facing.m_122428_();
        int ITERATE_LIMIT = this.walkwayWidth + 2;
        ArrayList<WalkwayBlockEntity> updateSecondPass = new ArrayList<WalkwayBlockEntity>();
        HashSet<BlockPos> iteratedBlocks = new HashSet<BlockPos>();
        iteratedBlocks.add(pos);
        block0: for (Direction dir : Iterate.directionsInAxis((Direction.Axis)left.m_122434_())) {
            BlockPos currentPos;
            BlockState currentState;
            Block block2;
            for (int i = 0; i < ITERATE_LIMIT && (block2 = (currentState = this.f_58857_.m_8055_(currentPos = pos.m_5484_(dir, i))).m_60734_()) instanceof WalkwayBlock; ++i) {
                WalkwayBlock otherWalkway;
                currentWalkway = otherWalkway = (WalkwayBlock)block2;
                if (i > 0) {
                    BlockEntity blockEntity = this.f_58857_.m_7702_(currentPos);
                    if (!(blockEntity instanceof WalkwayBlockEntity)) continue block0;
                    WalkwayBlockEntity otherWalkwayBE = (WalkwayBlockEntity)blockEntity;
                    iteratedBlocks.add(currentPos);
                    updateSecondPass.add(otherWalkwayBE);
                }
                if (!currentWalkway.connectedToWalkwayOnSide(this.f_58857_, currentState, currentPos, dir)) continue block0;
            }
        }
        if (!iteratedBlocks.contains(referencePos)) {
            this.widthReferencePos = pos;
        }
        this.walkwayWidth = actualWidth = iteratedBlocks.size();
        for (WalkwayBlockEntity walkwayBE : updateSecondPass) {
            walkwayBE.visualProgress = this.visualProgress;
            walkwayBE.setWalkwayWidth(actualWidth);
            walkwayBE.widthReferencePos = this.widthReferencePos;
            walkwayBE.updateCount = 1;
        }
    }

    public float calculateStressApplied() {
        return this.isController() ? super.calculateStressApplied() : 0.0f;
    }

    public AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(1.0);
    }

    public void clearKineticInformation() {
        super.clearKineticInformation();
        this.walkwayLength = 0;
        this.controller = null;
    }

    public WalkwayBlockEntity getControllerBE() {
        WalkwayBlockEntity walkway;
        BlockEntity blockEntity;
        if (this.controller == null || !this.f_58857_.m_46749_(this.controller)) {
            return null;
        }
        return this.controller != null && this.f_58857_.m_46749_(this.controller) && (blockEntity = this.f_58857_.m_7702_(this.controller)) instanceof WalkwayBlockEntity ? (walkway = (WalkwayBlockEntity)blockEntity) : null;
    }

    public void setController(BlockPos controller) {
        this.controller = controller;
    }

    public BlockPos getController() {
        return this.controller == null ? this.f_58858_ : this.controller;
    }

    public boolean isController() {
        return this.controller != null && this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public int getWalkwayWidth() {
        WalkwayBlockEntity controller = this.getControllerBE();
        return controller == null ? 1 : controller.walkwayWidth;
    }

    public void setWalkwayWidth(int width) {
        WalkwayBlockEntity controller = this.getControllerBE();
        if (controller != null) {
            controller.walkwayWidth = width;
        }
    }

    public boolean isEscalator() {
        Block block = this.m_58900_().m_60734_();
        if (!(block instanceof WalkwayBlock)) {
            return false;
        }
        WalkwayBlock walkwayBlock = (WalkwayBlock)block;
        WalkwaySlope slope = walkwayBlock.getWalkwaySlope(this.m_58900_());
        return slope != WalkwaySlope.HORIZONTAL && slope != WalkwaySlope.TERMINAL;
    }

    public List<BlockPos> getAllBlocks() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        WalkwayBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return list;
        }
        BlockPos current = controller.m_58899_();
        boolean terminal = false;
        for (int i = 0; i < this.walkwayLength; ++i) {
            list.add(current);
            BlockState state = this.f_58857_.m_8055_(current);
            if (!(state.m_60734_() instanceof WalkwayBlock)) {
                return new ArrayList<BlockPos>();
            }
            BlockPos nextPos = WalkwayBlock.nextSegmentPosition(state, current, !terminal, terminal);
            terminal = true;
            if (nextPos == null) break;
            current = nextPos;
        }
        return list;
    }

    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return super.canPropagateDiagonally(block, state) || this.isEscalator();
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (target instanceof WalkwayBlockEntity) {
            WalkwayBlockEntity walkway = (WalkwayBlockEntity)target;
            if (!connectedViaAxes) {
                return this.getController().equals((Object)walkway.getController()) ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    public float getWalkwayMovementSpeed() {
        return this.getSpeed() / 480.0f;
    }

    public float getVisualProgress() {
        WalkwayBlockEntity controller = this.getControllerBE();
        return controller == null ? 0.0f : controller.visualProgress;
    }

    public void setVisualProgress(float visualProgress) {
        this.visualProgress = visualProgress;
    }

    public boolean applyColor(@Nullable DyeColor colorIn) {
        if (colorIn == this.color) {
            return false;
        }
        if (this.f_58857_.f_46443_) {
            return true;
        }
        int WIDTH_LIMIT = 256;
        Direction facing = ((WalkwayBlock)this.m_58900_().m_60734_()).getFacing(this.m_58900_());
        Direction left = facing.m_122428_();
        List<BlockPos> walkwayChain = WalkwayBlock.getWalkwayChain(this.f_58857_, this.getController());
        for (BlockPos pos : walkwayChain) {
            block1: for (Direction dir : Iterate.directionsInAxis((Direction.Axis)left.m_122434_())) {
                for (int i = 0; i < WIDTH_LIMIT; ++i) {
                    WalkwayBlock walkwayBlock;
                    BlockState currentState;
                    Block block;
                    BlockPos currentPos = pos.m_5484_(dir, i);
                    WalkwayBlockEntity walkway = WalkwayHelper.getSegmentBE((LevelAccessor)this.f_58857_, currentPos);
                    if (walkway != null) {
                        walkway.color = colorIn;
                        walkway.notifyUpdate();
                    }
                    if (!((block = (currentState = this.f_58857_.m_8055_(currentPos)).m_60734_()) instanceof WalkwayBlock) || !(walkwayBlock = (WalkwayBlock)block).connectedToWalkwayOnSide(this.f_58857_, currentState, currentPos, dir)) continue block1;
                }
            }
        }
        return true;
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        if (this.controller != null) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        compound.m_128379_("IsController", this.isController());
        compound.m_128405_("Length", this.walkwayLength);
        if (this.isController()) {
            compound.m_128350_("VisualProgress", this.visualProgress);
            compound.m_128405_("Width", this.walkwayWidth);
            if (this.widthReferencePos != null) {
                compound.m_128365_("WidthReferencePos", (Tag)NbtUtils.m_129224_((BlockPos)this.widthReferencePos));
            }
        }
        if (this.color != null) {
            NBTHelper.writeEnum((CompoundTag)compound, (String)"Dye", (Enum)this.color);
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.resetClientRender) {
            compound.m_128379_("UpdateRendering", false);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.m_128471_("IsController")) {
            this.controller = this.f_58858_;
            this.visualProgress = compound.m_128457_("VisualProgress");
            this.walkwayWidth = compound.m_128451_("Width");
            this.widthReferencePos = compound.m_128425_("WidthReferencePos", 10) ? NbtUtils.m_129239_((CompoundTag)compound.m_128469_("WidthReferencePos")) : this.m_58899_();
        }
        DyeColor dyeColor = this.color = compound.m_128425_("Dye", 8) ? (DyeColor)NBTHelper.readEnum((CompoundTag)compound, (String)"Dye", DyeColor.class) : null;
        if (!this.wasMoved) {
            if (!this.isController()) {
                this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
            }
            this.walkwayLength = compound.m_128451_("Length");
        }
        if (!clientPacket) {
            return;
        }
        if (this.isController()) {
            this.lazyResetClientRender = true;
            float speed = this.getWalkwayMovementSpeed();
            this.visualProgress += speed * 1.0f;
            if (Math.abs(this.visualProgress) > 0.5f) {
                this.visualProgress = Math.signum(this.visualProgress) * (Math.abs(this.visualProgress) % 0.5f);
            }
        }
        this.resetClientRender |= compound.m_128441_("UpdateRendering");
    }

    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        if (this.color != null) {
            NBTHelper.writeEnum((CompoundTag)tag, (String)"Dye", (Enum)this.color);
        }
    }
}

