/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.escalated.index.EscalatedShapes;
import rbasamoyai.escalated.walkways.AbstractWalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayCaps;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;
import rbasamoyai.escalated.walkways.WideWalkwaySideBlock;

public class NarrowWalkwayBlock
extends AbstractWalkwayBlock {
    public NarrowWalkwayBlock(BlockBehaviour.Properties properties, NonNullSupplier<WalkwaySet> walkwaySetSupplier) {
        super(properties, walkwaySetSupplier);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)CAPS, (Comparable)((Object)WalkwayCaps.NO_SHAFT)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CAPS});
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        Direction leftFace = ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122428_();
        WalkwayCaps caps = (WalkwayCaps)((Object)state.m_61143_((Property)CAPS));
        return face == leftFace && !caps.hasLeftCap() || face == leftFace.m_122424_() && !caps.hasRightCap();
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.m_61143_((Property)CAPS) == newState.m_61143_((Property)CAPS);
    }

    @Override
    public WalkwaySlope getWalkwaySlope(BlockState state) {
        return WalkwaySlope.HORIZONTAL;
    }

    @Override
    public boolean hasWalkwayShaft(BlockState state) {
        return state.m_61143_((Property)CAPS) != WalkwayCaps.NO_SHAFT;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        if (AllBlocks.SHAFT.isIn(heldItem)) {
            if (state.m_61143_((Property)CAPS) != WalkwayCaps.NO_SHAFT) {
                return InteractionResult.PASS;
            }
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
            }
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)CAPS, (Comparable)((Object)WalkwayCaps.NONE))));
            ((ShaftBlock)AllBlocks.SHAFT.get()).playEncaseSound(level, pos);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockState newState = state;
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        Direction left = facing.m_122428_();
        Direction right = left.m_122424_();
        Direction clicked = context.m_43719_();
        WalkwayCaps caps = (WalkwayCaps)((Object)state.m_61143_((Property)CAPS));
        if (caps == WalkwayCaps.NO_SHAFT) {
            return InteractionResult.PASS;
        }
        if (clicked == left) {
            caps = caps.toggleLeft();
        }
        if (clicked == right) {
            caps = caps.toggleRight();
        }
        newState = (BlockState)newState.m_61124_((Property)CAPS, (Comparable)((Object)caps));
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)context.m_8083_(), (BlockState)this.updateAfterWrenched(newState, context));
        BlockState setState = level.m_8055_(context.m_8083_());
        if (setState != state) {
            AllSoundEvents.WRENCH_REMOVE.playOnServer(level, (Vec3i)context.m_8083_(), 1.0f, level.f_46441_.m_188501_() * 0.5f + 0.5f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (state.m_61143_((Property)CAPS) != WalkwayCaps.NO_SHAFT) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (player != null && !player.m_7500_()) {
                player.m_150109_().m_150079_(AllBlocks.SHAFT.asStack());
            }
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)CAPS, (Comparable)((Object)WalkwayCaps.NO_SHAFT))));
            AllSoundEvents.WRENCH_REMOVE.playOnServer(level, (Vec3i)pos, 1.0f, level.f_46441_.m_188501_() * 0.5f + 0.5f);
            return InteractionResult.SUCCESS;
        }
        return super.onSneakWrenched(state, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return EscalatedShapes.NARROW_WALKWAY.get((Direction)state.m_61143_(HORIZONTAL_FACING));
    }

    @Override
    public BlockState transformFromMerge(Level level, BlockState state, BlockPos pos, boolean left, boolean shaft, boolean remove, boolean replace) {
        if (remove) {
            return state;
        }
        WalkwayCaps caps = shaft ? WalkwayCaps.NONE : WalkwayCaps.NO_SHAFT;
        WalkwayCaps srcCaps = (WalkwayCaps)((Object)state.m_61143_((Property)CAPS));
        if (shaft && (srcCaps.hasRightCap() && left || srcCaps.hasLeftCap() && !left)) {
            caps = WalkwayCaps.BOTH;
        }
        return (BlockState)((BlockState)((BlockState)this.getWalkwaySet().getWideSideBlock(level, state, pos).m_61124_(HORIZONTAL_FACING, (Comparable)((Direction)state.m_61143_(HORIZONTAL_FACING)))).m_61124_((Property)WideWalkwaySideBlock.CAPS_SIDED, (Comparable)((Object)caps))).m_61124_((Property)WideWalkwaySideBlock.LEFT, (Comparable)Boolean.valueOf(!left));
    }

    @Override
    public boolean connectedToWalkwayOnSide(Level level, BlockState state, BlockPos pos, Direction face) {
        return face.m_122434_() == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    @Override
    public boolean isEscalator(Level level, BlockState state, BlockPos pos) {
        return false;
    }
}

