/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.handrails;

import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.Locale;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.index.EscalatedBlockEntities;
import rbasamoyai.escalated.walkways.WalkwayHelper;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public abstract class AbstractHandrailBlock
extends HorizontalDirectionalBlock
implements IBE<HandrailBlockEntity>,
ProperWaterloggedBlock {
    public static final EnumProperty<Side> SIDE = EnumProperty.m_61587_((String)"side", Side.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    protected AbstractHandrailBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, SIDE, WATERLOGGED});
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        int width = 1;
        boolean propagateBreak = true;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof HandrailBlockEntity) {
            HandrailBlockEntity handrailBlockEntity = (HandrailBlockEntity)blockEntity;
            width = handrailBlockEntity.width;
            propagateBreak = handrailBlockEntity.propagateBreak;
        }
        super.m_6810_(state, level, pos, newState, isMoving);
        if (level.f_46443_ || !propagateBreak || state.m_60734_() == newState.m_60734_() || isMoving) {
            return;
        }
        for (boolean forward : Iterate.trueAndFalse) {
            BlockState otherState;
            BlockPos otherPos = AbstractHandrailBlock.nextSegmentPosition(state, pos, forward);
            if (otherPos == null || !((otherState = level.m_8055_(otherPos)).m_60734_() instanceof AbstractHandrailBlock)) continue;
            BlockEntity blockEntity2 = level.m_7702_(otherPos);
            if (blockEntity2 instanceof HandrailBlockEntity) {
                HandrailBlockEntity handrailBE = (HandrailBlockEntity)blockEntity2;
                handrailBE.width = width;
            }
            level.m_7731_(otherPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)Blocks.f_50016_.m_49966_(), (BlockPos)otherPos), 3);
            level.m_46796_(2001, otherPos, Block.m_49956_((BlockState)otherState));
        }
        Side side = (Side)((Object)state.m_61143_(SIDE));
        if (side != Side.BOTH && width > 1) {
            Direction dir = (Direction)state.m_61143_((Property)f_54117_);
            Direction checkDir = side == Side.LEFT ? dir.m_122427_() : dir.m_122428_();
            BlockPos otherPos = pos.m_5484_(checkDir, width - 1);
            BlockEntity blockEntity3 = level.m_7702_(otherPos);
            if (blockEntity3 instanceof HandrailBlockEntity) {
                HandrailBlockEntity handrailBE = (HandrailBlockEntity)blockEntity3;
                handrailBE.width = 0;
            }
            level.m_7731_(otherPos, ProperWaterloggedBlock.withWater((LevelAccessor)level, (BlockState)Blocks.f_50016_.m_49966_(), (BlockPos)otherPos), 3);
            level.m_46796_(2001, otherPos, Block.m_49956_((BlockState)level.m_8055_(otherPos)));
        }
    }

    public abstract BlockState getStateForSlope(Level var1, BlockPos var2, BlockState var3, BlockPos var4, Direction var5, WalkwaySlope var6, Side var7);

    public Class<HandrailBlockEntity> getBlockEntityClass() {
        return HandrailBlockEntity.class;
    }

    public BlockEntityType<? extends HandrailBlockEntity> getBlockEntityType() {
        return (BlockEntityType)EscalatedBlockEntities.HANDRAIL.get();
    }

    public abstract WalkwaySlope getHandrailSlope(BlockState var1);

    public abstract boolean isEndHandrail(BlockState var1);

    public FluidState m_5888_(BlockState blockState) {
        return this.fluidState(blockState);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        boolean isDye = WalkwayHelper.isDye(heldItem);
        boolean hasWater = WalkwayHelper.hasWater(level, heldItem);
        if (isDye || hasWater) {
            return this.onBlockEntityUse((BlockGetter)level, pos, be -> be.setHandrailColor(WalkwayHelper.getDyeColorFromItem(heldItem)) ? InteractionResult.SUCCESS : InteractionResult.PASS);
        }
        boolean isGlass = heldItem.m_150930_(Blocks.f_50058_.m_5456_());
        if (isGlass && this.canConvertToGlassHandrail()) {
            this.convertToGlass(state, level, pos);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    protected void convertToGlass(BlockState state, Level level, BlockPos pos) {
        Direction direction;
        BlockPos offsetPos;
        BlockEntity blockEntity;
        HandrailBlockEntity handrailBE;
        if (level.f_46443_) {
            return;
        }
        int MAX_ITER = 1100;
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        Direction left = facing.m_122428_();
        Side side = (Side)((Object)state.m_61143_(SIDE));
        int width = 1;
        DyeColor color = null;
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof HandrailBlockEntity) {
            handrailBE = (HandrailBlockEntity)blockEntity2;
            width = handrailBE.width;
            color = handrailBE.getHandrailColor();
            handrailBE.propagateBreak = false;
        }
        level.m_7731_(pos, this.getGlassHandrail(state), 3);
        BlockEntity blockEntity3 = level.m_7702_(pos);
        if (blockEntity3 instanceof HandrailBlockEntity) {
            handrailBE = (HandrailBlockEntity)blockEntity3;
            handrailBE.width = width;
        }
        BlockPos offset = BlockPos.f_121853_;
        if (width > 1 && (blockEntity = level.m_7702_(offsetPos = pos.m_121955_((Vec3i)(offset = BlockPos.f_121853_.m_5484_(direction = side == Side.LEFT ? left.m_122424_() : left, width - 1))))) instanceof HandrailBlockEntity) {
            HandrailBlockEntity handrailBE2 = (HandrailBlockEntity)blockEntity;
            handrailBE2.propagateBreak = false;
            level.m_7731_(offsetPos, this.getGlassHandrail(level.m_8055_(offsetPos)), 3);
            BlockEntity blockEntity4 = level.m_7702_(offsetPos);
            if (blockEntity4 instanceof HandrailBlockEntity) {
                HandrailBlockEntity handrailBE1 = (HandrailBlockEntity)blockEntity4;
                handrailBE1.width = width;
            }
        }
        for (boolean forward : Iterate.trueAndFalse) {
            BlockPos iterPos = pos;
            BlockState iterState = state;
            for (int i = 0; i < MAX_ITER && (iterPos = AbstractHandrailBlock.nextSegmentPosition(iterState, iterPos, forward)) != null && (iterState = level.m_8055_(iterPos)).m_60734_() instanceof AbstractHandrailBlock; ++i) {
                BlockEntity blockEntity5;
                BlockEntity blockEntity6 = level.m_7702_(iterPos);
                if (blockEntity6 instanceof HandrailBlockEntity) {
                    HandrailBlockEntity other = (HandrailBlockEntity)blockEntity6;
                    other.propagateBreak = false;
                    level.m_7731_(iterPos, this.getGlassHandrail(iterState), 3);
                    blockEntity5 = level.m_7702_(iterPos);
                    if (blockEntity5 instanceof HandrailBlockEntity) {
                        HandrailBlockEntity other1 = (HandrailBlockEntity)blockEntity5;
                        other1.width = width;
                    }
                }
                BlockPos offsetPos2 = iterPos.m_121955_((Vec3i)offset);
                if (width <= 1 || !((blockEntity5 = level.m_7702_(offsetPos2)) instanceof HandrailBlockEntity)) continue;
                HandrailBlockEntity other = (HandrailBlockEntity)blockEntity5;
                other.propagateBreak = false;
                level.m_7731_(offsetPos2, this.getGlassHandrail(level.m_8055_(offsetPos2)), 3);
                BlockEntity blockEntity7 = level.m_7702_(offsetPos2);
                if (!(blockEntity7 instanceof HandrailBlockEntity)) continue;
                HandrailBlockEntity other1 = (HandrailBlockEntity)blockEntity7;
                other1.width = width;
            }
        }
        BlockEntity blockEntity8 = level.m_7702_(pos);
        if (blockEntity8 instanceof HandrailBlockEntity) {
            HandrailBlockEntity handrailBlockEntity = (HandrailBlockEntity)blockEntity8;
            handrailBlockEntity.setHandrailColor(color);
        }
    }

    protected abstract boolean canConvertToGlassHandrail();

    protected abstract BlockState getGlassHandrail(BlockState var1);

    public static BlockPos nextSegmentPosition(BlockState state, BlockPos pos, boolean forward) {
        int offset;
        AbstractHandrailBlock handrail = (AbstractHandrailBlock)state.m_60734_();
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        WalkwaySlope slope = handrail.getHandrailSlope(state);
        boolean isEnd = handrail.isEndHandrail(state);
        int n = offset = forward ? 1 : -1;
        if (slope == WalkwaySlope.TERMINAL && isEnd == forward) {
            return null;
        }
        pos = pos.m_5484_(direction, offset);
        if (slope == WalkwaySlope.MIDDLE) {
            return pos.m_6630_(offset);
        }
        if (slope == WalkwaySlope.TOP && !forward) {
            return pos.m_7495_();
        }
        if (slope == WalkwaySlope.BOTTOM && forward) {
            return pos.m_7494_();
        }
        return pos;
    }

    public static enum Side implements StringRepresentable
    {
        LEFT,
        RIGHT,
        BOTH;

        private final String id = this.name().toLowerCase(Locale.ROOT);

        public String m_7912_() {
            return this.id;
        }
    }
}

