/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.core.block.entity.BasketBlockEntity;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import net.satisfy.vinery.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasketBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING;
    public static final ResourceLocation CONTENTS;
    public static final BooleanProperty WATERLOGGED;
    private static final Supplier<VoxelShape> voxelShapeSupplier;
    public static final Map<Direction, VoxelShape> SHAPE;

    public BasketBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof BasketBlockEntity) {
            player.m_5893_((MenuProvider)((BasketBlockEntity)blockEntity));
        }
        return InteractionResult.CONSUME;
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(blockPos)) instanceof BasketBlockEntity) {
            BasketBlockEntity basketBlockEntity = (BasketBlockEntity)blockEntity;
            ItemStack itemStack = new ItemStack((ItemLike)blockState.m_60734_());
            basketBlockEntity.m_187476_(itemStack);
            double x = (double)blockPos.m_123341_() + 0.5;
            double y = (double)blockPos.m_123342_() + 0.5;
            double z = (double)blockPos.m_123343_() + 0.5;
            ItemEntity itemEntity = new ItemEntity(level, x, y, z, itemStack);
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    @NotNull
    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof BasketBlockEntity) {
            BasketBlockEntity basketBlockEntity = (BasketBlockEntity)blockEntity;
            builder = builder.m_287145_(CONTENTS, consumer -> {
                for (int i = 0; i < basketBlockEntity.m_6643_(); ++i) {
                    consumer.accept(basketBlockEntity.m_8020_(i));
                }
            });
        }
        return super.m_49635_(blockState, builder);
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = level.m_7702_(blockPos)) instanceof BasketBlockEntity) {
            ((BasketBlockEntity)blockEntity).m_58638_(itemStack.m_41786_());
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? BasketBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.BASKET_ENTITY.get()), BasketBlockEntity::lidAnimateTick) : null;
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.m_60713_(blockState2.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof BasketBlockEntity) {
                level.m_46717_(blockPos, blockState.m_60734_());
            }
            super.m_6810_(blockState, level, blockPos, blockState2, bl);
        }
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        ItemStack itemStack = super.m_7397_(blockGetter, blockPos, blockState);
        blockGetter.m_141902_(blockPos, (BlockEntityType)EntityTypeRegistry.BASKET_ENTITY.get()).ifPresent(basketBlockEntity -> basketBlockEntity.m_187476_(itemStack));
        return itemStack;
    }

    @NotNull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(blockPos));
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        FluidState fluidState = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BasketBlockEntity(blockPos, blockState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public boolean m_7357_(BlockState arg, BlockGetter arg2, BlockPos arg3, PathComputationType arg4) {
        return false;
    }

    static {
        voxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.3125, (double)0.4375, (double)0.125, (double)0.8125, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.3125, (double)0.4375, (double)0.875, (double)0.8125, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.8125, (double)0.4375, (double)0.875, (double)0.8125, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.1875, (double)0.875, (double)0.4375, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
            return shape;
        };
        SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
            }
        });
        FACING = HorizontalDirectionalBlock.f_54117_;
        WATERLOGGED = BlockStateProperties.f_61362_;
        CONTENTS = new ResourceLocation("contents");
    }
}

