/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.init;

import java.util.Collections;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class CMRTags {
    public static <T> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return registry.tags().createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return CMRTags.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return CMRTags.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return CMRTags.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return CMRTags.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    public static void init() {
        CMRBlockTags.init();
        CMRItemTags.init();
        CMRFluidTags.init();
        CMREntityTags.init();
        CMRRecipeSerializerTags.init();
    }

    public static final class CMRBlockTags
    extends Enum<CMRBlockTags> {
        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ CMRBlockTags[] $VALUES;

        public static CMRBlockTags[] values() {
            return (CMRBlockTags[])$VALUES.clone();
        }

        public static CMRBlockTags valueOf(String name) {
            return Enum.valueOf(CMRBlockTags.class, name);
        }

        private CMRBlockTags() {
            this(NameSpace.MOD);
        }

        private CMRBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CMRBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CMRTags.optionalTag(ForgeRegistries.BLOCKS, id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.m_41720_()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).m_40614_());
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        private static void init() {
        }

        private static /* synthetic */ CMRBlockTags[] $values() {
            return new CMRBlockTags[0];
        }

        static {
            $VALUES = CMRBlockTags.$values();
        }
    }

    public static enum CMRItemTags {
        SNOWMAN_COOLER_FUEL_REGULAR(NameSpace.MOD, "snowman_cooler_fuel/regular"),
        SNOWMAN_COOLER_FUEL_SPECIAL(NameSpace.MOD, "snowman_cooler_fuel/special");

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private CMRItemTags() {
            this(NameSpace.MOD);
        }

        private CMRItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CMRItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CMRTags.optionalTag(ForgeRegistries.ITEMS, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        private static void init() {
        }
    }

    public static final class CMRFluidTags
    extends Enum<CMRFluidTags> {
        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ CMRFluidTags[] $VALUES;

        public static CMRFluidTags[] values() {
            return (CMRFluidTags[])$VALUES.clone();
        }

        public static CMRFluidTags valueOf(String name) {
            return Enum.valueOf(CMRFluidTags.class, name);
        }

        private CMRFluidTags() {
            this(NameSpace.MOD);
        }

        private CMRFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRFluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CMRFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CMRTags.optionalTag(ForgeRegistries.FLUIDS, id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.m_205070_(this.tag);
        }

        private static void init() {
        }

        private static /* synthetic */ CMRFluidTags[] $values() {
            return new CMRFluidTags[0];
        }

        static {
            $VALUES = CMRFluidTags.$values();
        }
    }

    public static enum CMREntityTags {
        SNOWMAN_COOLER_CAPTURABLE;

        public final TagKey<EntityType<?>> tag;
        public final boolean alwaysDatagen;

        private CMREntityTags() {
            this(NameSpace.MOD);
        }

        private CMREntityTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMREntityTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMREntityTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CMREntityTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CMRTags.optionalTag(ForgeRegistries.ENTITY_TYPES, id) : TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(EntityType<?> type) {
            return type.m_204039_(this.tag);
        }

        public boolean matches(Entity entity) {
            return this.matches(entity.m_6095_());
        }

        private static void init() {
        }
    }

    public static final class CMRRecipeSerializerTags
    extends Enum<CMRRecipeSerializerTags> {
        public final TagKey<RecipeSerializer<?>> tag;
        public final boolean alwaysDatagen;
        private static final /* synthetic */ CMRRecipeSerializerTags[] $VALUES;

        public static CMRRecipeSerializerTags[] values() {
            return (CMRRecipeSerializerTags[])$VALUES.clone();
        }

        public static CMRRecipeSerializerTags valueOf(String name) {
            return Enum.valueOf(CMRRecipeSerializerTags.class, name);
        }

        private CMRRecipeSerializerTags() {
            this(NameSpace.MOD);
        }

        private CMRRecipeSerializerTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRRecipeSerializerTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CMRRecipeSerializerTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CMRRecipeSerializerTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CMRTags.optionalTag(ForgeRegistries.RECIPE_SERIALIZERS, id) : TagKey.m_203882_((ResourceKey)Registries.f_256764_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(RecipeSerializer<?> recipeSerializer) {
            return ((Holder)ForgeRegistries.RECIPE_SERIALIZERS.getHolder(recipeSerializer).orElseThrow()).m_203656_(this.tag);
        }

        private static void init() {
        }

        private static /* synthetic */ CMRRecipeSerializerTags[] $values() {
            return new CMRRecipeSerializerTags[0];
        }

        static {
            $VALUES = CMRRecipeSerializerTags.$values();
        }
    }

    public static enum NameSpace {
        MOD("cmr", false, true),
        FORGE("forge"),
        CREATE("create");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

