/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.cooler;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.content.logistics.stockTicker.StockTickerInteractionHandler;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import fr.iglee42.cmr.cooler.SnowmanCoolerBlockEntity;
import fr.iglee42.cmr.init.CMRRegistries;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.lang.Lang;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SnowmanCoolerBlock
extends HorizontalDirectionalBlock
implements IBE<SnowmanCoolerBlockEntity>,
IWrenchable {
    public static final EnumProperty<HeatLevel> HEAT_LEVEL = EnumProperty.m_61587_((String)"snowman", HeatLevel.class);

    public SnowmanCoolerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(HEAT_LEVEL, (Comparable)((Object)HeatLevel.IDLE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HEAT_LEVEL, f_54117_});
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos.m_7494_());
        if (!(blockEntity instanceof BasinBlockEntity)) {
            return;
        }
        BasinBlockEntity basin = (BasinBlockEntity)blockEntity;
        basin.notifyChangeOfContents();
    }

    public Class<SnowmanCoolerBlockEntity> getBlockEntityClass() {
        return SnowmanCoolerBlockEntity.class;
    }

    public BlockEntityType<? extends SnowmanCoolerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CMRRegistries.COOLER.get();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        ItemStack heldItem = player.m_21120_(hand);
        if (AllItems.GOGGLES.isIn(heldItem)) {
            return this.onBlockEntityUse((BlockGetter)world, pos, bbte -> {
                if (bbte.goggles) {
                    return InteractionResult.PASS;
                }
                bbte.goggles = true;
                bbte.notifyUpdate();
                return InteractionResult.SUCCESS;
            });
        }
        SnowmanCoolerBlockEntity be = (SnowmanCoolerBlockEntity)this.getBlockEntity((BlockGetter)world, pos);
        if (be != null && be.stockKeeper) {
            StockTickerBlockEntity stockTicker = SnowmanCoolerBlockEntity.getStockTicker((LevelAccessor)world, pos);
            if (stockTicker != null) {
                StockTickerInteractionHandler.interactWithLogisticsManagerAt((Player)player, (Level)world, (BlockPos)stockTicker.m_58899_());
            }
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41619_()) {
            return this.onBlockEntityUse((BlockGetter)world, pos, bbte -> {
                if (!bbte.goggles) {
                    return InteractionResult.PASS;
                }
                bbte.goggles = false;
                bbte.notifyUpdate();
                return InteractionResult.SUCCESS;
            });
        }
        boolean doNotConsume = player.m_7500_();
        boolean forceOverflow = !(player instanceof FakePlayer);
        InteractionResultHolder<ItemStack> res = SnowmanCoolerBlock.tryInsert(state, world, pos, heldItem, doNotConsume, forceOverflow, false);
        ItemStack leftover = (ItemStack)res.m_19095_();
        if (!(world.f_46443_ || doNotConsume || leftover.m_41619_())) {
            if (heldItem.m_41619_()) {
                player.m_21008_(hand, leftover);
            } else if (!player.m_150109_().m_36054_(leftover)) {
                player.m_36176_(leftover, false);
            }
        }
        return res.m_19089_() == InteractionResult.SUCCESS ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public static InteractionResultHolder<ItemStack> tryInsert(BlockState state, Level world, BlockPos pos, ItemStack stack, boolean doNotConsume, boolean forceOverflow, boolean simulate) {
        if (!state.m_155947_()) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        BlockEntity be = world.m_7702_(pos);
        if (!(be instanceof SnowmanCoolerBlockEntity)) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        SnowmanCoolerBlockEntity burnerBE = (SnowmanCoolerBlockEntity)be;
        if (burnerBE.isCreativeFuel(stack)) {
            if (!simulate) {
                burnerBE.applyCreativeFuel();
            }
            return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
        }
        if (!burnerBE.tryUpdateFuel(stack, forceOverflow, simulate)) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        if (!doNotConsume) {
            ItemStack container;
            ItemStack itemStack = stack.hasCraftingRemainingItem() ? stack.getCraftingRemainingItem() : (container = stack.m_41720_().equals(Items.f_151055_) ? new ItemStack((ItemLike)Items.f_42446_) : ItemStack.f_41583_);
            if (!world.f_46443_) {
                stack.m_41774_(1);
            }
            return InteractionResultHolder.m_19090_((Object)container);
        }
        return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        ItemStack stack = context.m_43722_();
        Item item = stack.m_41720_();
        BlockState defaultState = this.m_49966_();
        HeatLevel initialHeat = HeatLevel.IDLE;
        return (BlockState)((BlockState)defaultState.m_61124_(HEAT_LEVEL, (Comparable)((Object)initialHeat))).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return AllShapes.HEATER_BLOCK_SHAPE;
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        if (p_220071_4_ == CollisionContext.m_82749_()) {
            return AllShapes.HEATER_BLOCK_SPECIAL_COLLISION_SHAPE;
        }
        return this.m_5940_(p_220071_1_, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    public boolean m_7278_(BlockState p_149740_1_) {
        return true;
    }

    public int m_6782_(BlockState state, Level p_180641_2_, BlockPos p_180641_3_) {
        return Math.max(0, ((HeatLevel)((Object)state.m_61143_(HEAT_LEVEL))).ordinal() - 1);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static HeatLevel getHeatLevelOf(BlockState blockState) {
        return blockState.m_61138_(HEAT_LEVEL) ? (HeatLevel)((Object)blockState.m_61143_(HEAT_LEVEL)) : HeatLevel.IDLE;
    }

    public static LootTable.Builder buildLootTable() {
        LootItemCondition.Builder survivesExplosion = ExplosionCondition.m_81661_();
        SnowmanCoolerBlock block = (SnowmanCoolerBlock)((Object)CMRRegistries.SNOWMAN_COOLER.get());
        LootTable.Builder builder = LootTable.m_79147_();
        LootPool.Builder poolBuilder = LootPool.m_79043_();
        for (HeatLevel level : HeatLevel.values()) {
            ItemLike drop = (ItemLike)CMRRegistries.SNOWMAN_COOLER.get();
            poolBuilder.m_79076_(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)drop).m_79080_(survivesExplosion)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(HEAT_LEVEL, (Comparable)((Object)level)))));
        }
        builder.m_79161_(poolBuilder.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)));
        return builder;
    }

    public static enum HeatLevel implements StringRepresentable
    {
        IDLE,
        FADING,
        COOLING,
        FREEZING;


        public static HeatLevel byIndex(int index) {
            return HeatLevel.values()[index];
        }

        public HeatLevel nextActiveLevel() {
            return HeatLevel.byIndex(this.ordinal() + 1 > HeatLevel.values().length - 1 ? 0 : this.ordinal() + 1);
        }

        public boolean isAtLeast(HeatLevel heatLevel) {
            return this.ordinal() >= heatLevel.ordinal();
        }

        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }
}

