/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.cmr.cooler;

import fr.iglee42.cmr.init.CMRRegistries;
import fr.iglee42.cmr.init.CMRTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EmptyCoolerBlockItem
extends BlockItem {
    public EmptyCoolerBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockEntity be = world.m_7702_(pos);
        Player player = context.m_43723_();
        if (!(be instanceof SpawnerBlockEntity)) {
            return super.m_6225_(context);
        }
        BaseSpawner spawner = ((SpawnerBlockEntity)be).m_59801_();
        List<SpawnData> possibleSpawns = spawner.f_45443_.m_146338_().stream().map(WeightedEntry.Wrapper::m_146310_).toList();
        if (possibleSpawns.isEmpty()) {
            possibleSpawns = new ArrayList<SpawnData>();
            possibleSpawns.add(spawner.f_45444_);
        }
        for (SpawnData e : possibleSpawns) {
            Optional optionalEntity = EntityType.m_20637_((CompoundTag)e.f_186561_());
            if (optionalEntity.isEmpty() || !CMRTags.CMREntityTags.SNOWMAN_COOLER_CAPTURABLE.matches((EntityType)optionalEntity.get())) continue;
            EmptyCoolerBlockItem.spawnCaptureEffects(world, VecHelper.getCenterOf((Vec3i)pos));
            if (world.f_46443_ || player == null) {
                return InteractionResult.SUCCESS;
            }
            this.giveBurnerItemTo(player, context.m_43722_(), context.m_43724_());
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public InteractionResult m_6880_(ItemStack heldItem, Player player, LivingEntity entity, InteractionHand hand) {
        if (!CMRTags.CMREntityTags.SNOWMAN_COOLER_CAPTURABLE.matches((Entity)entity)) {
            return InteractionResult.PASS;
        }
        Level world = player.m_9236_();
        EmptyCoolerBlockItem.spawnCaptureEffects(world, entity.m_20182_());
        if (world.f_46443_) {
            return InteractionResult.FAIL;
        }
        this.giveBurnerItemTo(player, heldItem, hand);
        entity.m_146870_();
        return InteractionResult.FAIL;
    }

    protected void giveBurnerItemTo(Player player, ItemStack heldItem, InteractionHand hand) {
        ItemStack filled = CMRRegistries.SNOWMAN_COOLER.asStack();
        if (!player.m_7500_()) {
            heldItem.m_41774_(1);
        }
        if (heldItem.m_41619_()) {
            player.m_21008_(hand, filled);
            return;
        }
        player.m_150109_().m_150079_(filled);
    }

    public static void spawnCaptureEffects(Level world, Vec3 vec) {
        if (world.f_46443_) {
            for (int i = 0; i < 40; ++i) {
                Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)world.f_46441_, (float)0.125f);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123754_, vec.f_82479_, vec.f_82480_, vec.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                world.m_7106_((ParticleOptions)ParticleTypes.f_175821_, vec.f_82479_, vec.f_82480_, vec.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                Vec3 circle = motion.m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(0.5);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, circle.f_82479_, vec.f_82480_, circle.f_82481_, 0.0, -0.125, 0.0);
            }
            return;
        }
        BlockPos soundPos = BlockPos.m_274446_((Position)vec);
        world.m_5594_(null, soundPos, SoundEvents.f_12478_, SoundSource.HOSTILE, 0.25f, 0.75f);
        world.m_5594_(null, soundPos, SoundEvents.f_144089_, SoundSource.HOSTILE, 0.5f, 0.75f);
    }
}

