/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import java.text.DecimalFormat;

public class NumberUtil {
    public static String GetPrettyString(int count) {
        return new DecimalFormat().format(count);
    }

    public static boolean IsIntegerOrEmpty(String text) {
        return text.isEmpty() || NumberUtil.IsInteger(text);
    }

    public static boolean IsInteger(String text) {
        if (text == null) {
            return false;
        }
        try {
            int n = Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static int GetIntegerValue(String text, int defaultValue) {
        if (NumberUtil.IsInteger(text)) {
            return Integer.parseInt(text);
        }
        return defaultValue;
    }

    public static boolean IsLongOrEmpty(String text) {
        return text.isEmpty() || NumberUtil.IsLong(text);
    }

    public static boolean IsLong(String text) {
        if (text == null) {
            return false;
        }
        try {
            long l = Long.parseLong(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static long GetLongValue(String text, long defaultValue) {
        if (NumberUtil.IsLong(text)) {
            return Long.parseLong(text);
        }
        return defaultValue;
    }

    public static boolean IsFloatOrEmpty(String text) {
        return text.isEmpty() || NumberUtil.IsFloat(text);
    }

    public static boolean IsFloat(String text) {
        if (text == null) {
            return false;
        }
        try {
            float f = Float.parseFloat(text);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static float GetFloatValue(String text, float defaultValue) {
        if (NumberUtil.IsFloat(text)) {
            return Float.parseFloat(text);
        }
        return defaultValue;
    }

    public static boolean IsDoubleOrEmpty(String text) {
        return text.isEmpty() || NumberUtil.IsDouble(text);
    }

    public static boolean IsDouble(String text) {
        if (text == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(text);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static double GetDoubleValue(String text, double defaultValue) {
        if (NumberUtil.IsDouble(text)) {
            return Double.parseDouble(text);
        }
        return defaultValue;
    }
}

