/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.player;

import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.network.message.player.SPacketUpdatePlayerCache;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class CPacketRequestID
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketRequestID> HANDLER = new H();
    private final String playerName;

    public CPacketRequestID(@Nonnull String playerName) {
        this.playerName = playerName;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.m_130070_(this.playerName);
    }

    private static class H
    extends CustomPacket.Handler<CPacketRequestID> {
        private H() {
        }

        @Override
        @Nonnull
        public CPacketRequestID decode(@Nonnull FriendlyByteBuf buffer) {
            return new CPacketRequestID(buffer.m_130277_());
        }

        @Override
        protected void handle(@Nonnull CPacketRequestID message, @Nullable ServerPlayer sender) {
            UUID id = PlayerReference.getPlayerID(message.playerName);
            if (id != null) {
                String name = PlayerReference.getPlayerName(id);
                new SPacketUpdatePlayerCache(id, name == null ? message.playerName : name).sendTo(sender);
            }
        }
    }
}

