/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.config;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.api.config.options.MapLikeOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParsingException;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class SPacketEditMapConfig
extends ServerToClientPacket {
    public static final CustomPacket.Handler<SPacketEditMapConfig> HANDLER = new H();
    private final ResourceLocation fileID;
    private final String option;
    private final String input;
    private final String key;
    private final boolean isSet;

    public SPacketEditMapConfig(@Nonnull ResourceLocation fileID, @Nonnull String option, @Nonnull String input, String key, boolean isSet) {
        this.fileID = fileID;
        this.option = option;
        this.input = input;
        this.key = key;
        this.isSet = isSet;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.m_130085_(this.fileID);
        buffer.m_130070_(this.option);
        buffer.m_130070_(this.input);
        buffer.m_130070_(this.key);
        buffer.writeBoolean(this.isSet);
    }

    private static class H
    extends CustomPacket.Handler<SPacketEditMapConfig> {
        private H() {
        }

        @Override
        @Nonnull
        public SPacketEditMapConfig decode(@Nonnull FriendlyByteBuf buffer) {
            return new SPacketEditMapConfig(buffer.m_130281_(), buffer.m_130277_(), buffer.m_130277_(), buffer.m_130277_(), buffer.readBoolean());
        }

        @Override
        protected void handle(@Nonnull SPacketEditMapConfig message, @Nullable ServerPlayer sender) {
            ConfigFile file = ConfigFile.lookupFile(message.fileID);
            if (file != null && file.isClientOnly()) {
                ConfigOption<?> configOption;
                Map<String, ConfigOption<?>> optionMap = file.getAllOptions();
                if (optionMap.containsKey(message.option) && (configOption = optionMap.get(message.option)) instanceof MapLikeOption) {
                    MapLikeOption option = (MapLikeOption)configOption;
                    Pair<Boolean, ConfigParsingException> result = option.editMap(message.input, message.key, message.isSet);
                    if (!((Boolean)result.getFirst()).booleanValue()) {
                        LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_EDIT_FAIL_PARSE.get(((ConfigParsingException)result.getSecond()).getMessage()).m_130940_(ChatFormatting.RED));
                        return;
                    }
                    if (!message.isSet) {
                        LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_EDIT_LIST_REMOVE_SUCCESS.get(message.option + "[" + message.key + "]"));
                    }
                    LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_EDIT_SUCCESS.get(message.option + "[" + message.key + "]", message.input));
                    return;
                }
                LightmansCurrency.getProxy().sendClientMessage((Component)LCText.COMMAND_CONFIG_FAIL_MISSING.get(message.option).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

