/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.quark;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.variants.WoodType;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodData;
import io.github.lightman314.lightmanscurrency.datagen.util.WoodDataHelper;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.ForgeRegistries;
import org.violetmoon.quark.base.handler.WoodSetHandler;
import org.violetmoon.quark.content.world.module.AncientWoodModule;
import org.violetmoon.quark.content.world.module.BlossomTreesModule;

public class QuarkCustomWoodTypes {
    private static final String MODID = "quark";
    public static final WoodType ANCIENT = WoodType.builder("ancient", "quark").ofColor(MapColor.f_283919_).ofName("Ashen").build();
    public static final WoodType AZALEA = WoodType.builder("azalea", "quark").ofColor(MapColor.f_283916_).ofName("Azalea").build();
    public static final WoodType BLOSSOM = WoodType.builder("blossom", "quark").ofColor(MapColor.f_283913_).ofName("Trumpet").build();

    public static void setupWoodTypes() {
        QuarkCustomWoodTypes.registerSet(ANCIENT, () -> AncientWoodModule.woodSet);
        QuarkCustomWoodTypes.registerSet(BLOSSOM, () -> BlossomTreesModule.woodSet);
        WoodDataHelper.register(AZALEA, WoodData.of2(QuarkCustomWoodTypes.item("azalea_log"), QuarkCustomWoodTypes.item("azalea_planks"), QuarkCustomWoodTypes.item("azalea_planks_slab"), "quark:block/azalea_log", "quark:block/azalea_log_top", "quark:block/azalea_planks"));
    }

    private static void registerSet(@Nonnull WoodType type, @Nonnull Supplier<WoodSetHandler.WoodSet> set) {
        WoodDataHelper.register(type, WoodData.of2(QuarkCustomWoodTypes.log(set), QuarkCustomWoodTypes.plank(set), QuarkCustomWoodTypes.slab(type), "quark:block/" + type.id + "_log", "quark:block/" + type.id + "_log_top", "quark:block/" + type.id + "_planks"));
    }

    private static Supplier<ItemLike> log(@Nonnull Supplier<WoodSetHandler.WoodSet> set) {
        return () -> {
            WoodSetHandler.WoodSet s = (WoodSetHandler.WoodSet)set.get();
            if (s == null) {
                return null;
            }
            return s.log;
        };
    }

    private static Supplier<ItemLike> plank(@Nonnull Supplier<WoodSetHandler.WoodSet> set) {
        return () -> {
            WoodSetHandler.WoodSet s = (WoodSetHandler.WoodSet)set.get();
            if (s == null) {
                return null;
            }
            return s.planks;
        };
    }

    private static Supplier<ItemLike> slab(@Nonnull WoodType type) {
        return () -> {
            ResourceLocation itemID = VersionUtil.modResource(MODID, type.id + "_planks_slab");
            Item result = (Item)ForgeRegistries.ITEMS.getValue(itemID);
            if (result == Items.f_41852_) {
                return null;
            }
            LightmansCurrency.LogDebug("Manually found the quark slab for wood type " + type.id + " since quark screwed this up and made their variant handler return the method input instead of the variant that was made...");
            return result;
        };
    }

    private static Supplier<ItemLike> item(@Nonnull String itemID) {
        return () -> {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(VersionUtil.modResource(MODID, itemID));
            if (item == Items.f_41852_) {
                return null;
            }
            return item;
        };
    }
}

