/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.jade.providers;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.PaygateBlockEntity;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class PaygateComponentProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public final ResourceLocation ID = VersionUtil.lcResource("paygate");
    public static final PaygateComponentProvider INSTANCE = new PaygateComponentProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        PaygateBlockEntity be;
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof PaygateBlockEntity && (be = (PaygateBlockEntity)blockEntity).isActive() && accessor.getServerData().m_128441_("OutputData")) {
            List<PaygateBlockEntity.OutputVisibilityData> list = PaygateBlockEntity.parseVisibilityData(accessor.getServerData().m_128469_("OutputData"));
            for (PaygateBlockEntity.OutputVisibilityData data : list) {
                int seconds = MathUtil.DivideByAndRoundUp(data.timer(), 20);
                MutableComponent timeText = EasyText.literal(String.valueOf(seconds)).m_7220_((Component)LCText.TIME_UNIT_SECOND.shortText.get(new Object[0]));
                String name = data.name();
                if (name == null && data.sides().size() == 6) {
                    tooltip.add((Component)LCText.TOOLTIP_TRADER_PAYGATE_TIME_REMAINING.get(timeText).m_130940_(ChatFormatting.GRAY));
                    continue;
                }
                MutableComponent nameText = name == null ? this.getSidesList(data) : EasyText.literal(name);
                tooltip.add((Component)LCText.TOOLTIP_TRADER_PAYGATE_SIDED_TIME_REMAINING.get(nameText, timeText).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    private MutableComponent getSidesList(PaygateBlockEntity.OutputVisibilityData data) {
        MutableComponent text = EasyText.empty();
        for (Direction side : data.sides()) {
            if (!text.getString().isEmpty()) {
                text.m_7220_((Component)LCText.GUI_SEPERATOR.get(new Object[0]));
            }
            text.m_7220_((Component)LCText.GUI_INPUT_SIDES.get(side).get(new Object[0]));
        }
        return text;
    }

    public ResourceLocation getUid() {
        return this.ID;
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof PaygateBlockEntity) {
            PaygateBlockEntity be = (PaygateBlockEntity)blockEntity;
            be.saveRedstoneData(compoundTag);
        }
    }
}

