/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.ftbteams.ownership;

import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.AbstractTeamBase;
import io.github.lightman314.lightmanscurrency.api.ownership.listing.IPotentialOwnerProvider;
import io.github.lightman314.lightmanscurrency.api.ownership.listing.PotentialOwner;
import io.github.lightman314.lightmanscurrency.integration.ftbteams.ownership.PotentialFTBTeamOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Player;

public class FTBTeamOwnerProvider
implements IPotentialOwnerProvider {
    @Override
    @Nonnull
    public List<PotentialOwner> collectPotentialOwners(@Nonnull Player player) {
        UUID playerID = player.m_20148_();
        ArrayList<PotentialOwner> results = new ArrayList<PotentialOwner>();
        for (Team team : this.allTeams(player.m_9236_().f_46443_)) {
            AbstractTeamBase t;
            if (!(team instanceof AbstractTeamBase) || !(t = (AbstractTeamBase)team).isMember(playerID) || t.isPlayerTeam()) continue;
            results.add(new PotentialFTBTeamOwner(t.getTeamId()));
        }
        return results;
    }

    private Collection<Team> allTeams(boolean isClient) {
        if (isClient && FTBTeamsAPI.api().isClientManagerLoaded()) {
            ClientTeamManager manager = FTBTeamsAPI.api().getClientManager();
            return manager.getTeams();
        }
        if (FTBTeamsAPI.api().isManagerLoaded()) {
            TeamManager manager = FTBTeamsAPI.api().getManager();
            return manager.getTeams();
        }
        return Collections.emptyList();
    }
}

