/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.create.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.integration.create.attributes.LCItemAttributes;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CoinAttributeType
implements ItemAttributeType {
    private static final CoinAttribute IS_COIN_ATTRIBUTE = new CoinAttribute("");
    private static final CoinAttribute ANCIENT_COIN_ATTRIBUTE = new CoinAttribute(true);

    public ItemAttribute createAttribute() {
        return new CoinAttribute("");
    }

    public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
        ChainData chain = CoinAPI.API.ChainDataOfCoin(stack);
        if (chain != null) {
            return List.of(IS_COIN_ATTRIBUTE, new CoinAttribute(chain.chain));
        }
        if (stack.m_41720_() == ModItems.COIN_ANCIENT.get()) {
            return List.of(IS_COIN_ATTRIBUTE, ANCIENT_COIN_ATTRIBUTE);
        }
        return List.of();
    }

    public static class CoinAttribute
    implements ItemAttribute {
        private boolean ancientCoin;
        private String chain;

        private CoinAttribute(boolean ancient) {
            this.ancientCoin = true;
            this.chain = "";
        }

        private CoinAttribute(String chain) {
            this.ancientCoin = false;
            this.chain = chain;
        }

        public boolean appliesTo(ItemStack stack, Level world) {
            if (this.ancientCoin) {
                return stack.m_41720_() == ModItems.COIN_ANCIENT.get();
            }
            ChainData data = CoinAPI.API.ChainDataOfCoin(stack);
            if (data == null) {
                return false;
            }
            if (this.isNullType()) {
                return stack.m_41720_() == ModItems.COIN_ANCIENT.get();
            }
            return data.chain.equals(this.chain);
        }

        public ItemAttributeType getType() {
            return LCItemAttributes.COIN_ATTRIBUTE.get();
        }

        public void save(CompoundTag tag) {
            if (this.ancientCoin) {
                tag.m_128379_("Ancient", true);
            } else {
                tag.m_128359_("Chain", this.chain);
            }
        }

        public void load(CompoundTag tag) {
            if (tag.m_128471_("Ancient")) {
                this.ancientCoin = true;
                this.chain = "";
            } else {
                this.ancientCoin = false;
                this.chain = tag.m_128461_("Chain");
            }
        }

        private boolean isNullType() {
            return this.chain.isEmpty();
        }

        private Component getChainName() {
            ChainData data = CoinAPI.API.ChainData(this.chain);
            return data == null ? EasyText.literal(this.chain) : data.getDisplayName();
        }

        public String getTranslationKey() {
            return this.chain.isEmpty() && !this.ancientCoin ? "lightmanscurrency.coin.any" : "lightmanscurrency.coin.chain";
        }

        public Object[] getTranslationParameters() {
            Object[] objectArray;
            if (this.ancientCoin) {
                return new Object[]{LCText.ANCIENT_COIN_VALUE_NAME.get(new Object[0])};
            }
            if (this.isNullType()) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.getChainName();
            }
            return objectArray;
        }
    }
}

