/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.trader;

import com.google.common.base.Predicates;
import com.mojang.datafixers.util.Either;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.builtin.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.stats.StatType;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.integration.computercraft.data.LCLuaTable;
import io.github.lightman314.lightmanscurrency.integration.computercraft.peripheral.AccessTrackingPeripheral;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;

public abstract class TraderPeripheral<BE extends TraderBlockEntity<T>, T extends TraderData>
extends AccessTrackingPeripheral {
    public static final String BASE_TYPE = "lc_trader";
    protected final Either<BE, Long> source;

    public TraderPeripheral(BE be) {
        this.source = Either.left(be);
    }

    public TraderPeripheral(T trader) {
        this.source = Either.right((Object)((TraderData)trader).getID());
    }

    public static IPeripheral createSimple(TraderBlockEntity<TraderData> be) {
        return new Simple(be);
    }

    public static IPeripheral createSimple(TraderData trader) {
        return new Simple(trader);
    }

    protected boolean isAuthorized() {
        return false;
    }

    @Nullable
    protected final BE getBlockEntity() {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        this.source.ifLeft(result::set);
        return (BE)((TraderBlockEntity)result.get());
    }

    @Nullable
    public T safeGetTrader() {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        this.source.ifLeft(be -> {
            if (be.m_58901_()) {
                return;
            }
            result.set(be.getTraderData());
        });
        this.source.ifRight(id -> {
            try {
                result.set(TraderAPI.API.GetTrader(false, (long)id));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return (T)((TraderData)result.get());
    }

    @Nonnull
    protected T getTrader() throws LuaException {
        if (!this.stillValid()) {
            throw new LuaException("An unexpected error occurred trying to get the traders data!");
        }
        T trader = this.safeGetTrader();
        if (trader == null) {
            throw new LuaException("An unexpected error occurred trying to get the traders data!");
        }
        return trader;
    }

    public Set<String> getAdditionalTypes() {
        return Set.of(BASE_TYPE);
    }

    @Override
    public boolean equals(@Nullable IPeripheral peripheral) {
        if (peripheral instanceof TraderPeripheral) {
            TraderPeripheral other = (TraderPeripheral)peripheral;
            return other.source.equals(this.source) && super.equals(peripheral);
        }
        return false;
    }

    @LuaFunction(mainThread=true)
    public boolean isValid() {
        try {
            this.getTrader();
            return true;
        }
        catch (LuaException e) {
            return false;
        }
    }

    @LuaFunction(mainThread=true)
    public long getID() throws LuaException {
        return ((TraderData)this.getTrader()).getID();
    }

    @LuaFunction(mainThread=true)
    public boolean isVisibleOnNetwork() throws LuaException {
        return ((TraderData)this.getTrader()).showOnTerminal();
    }

    @LuaFunction(mainThread=true)
    public boolean isCreative() throws LuaException {
        return ((TraderData)this.getTrader()).isCreative();
    }

    @LuaFunction(mainThread=true)
    public boolean isPersistent() throws LuaException {
        return ((TraderData)this.getTrader()).isPersistent();
    }

    @LuaFunction
    public LCLuaTable getOwner() throws LuaException {
        T trader = this.getTrader();
        Owner owner = ((TraderData)trader).getOwner().getValidOwner();
        LCLuaTable table = LCLuaTable.fromTag(owner.save());
        if (owner instanceof PlayerOwner) {
            PlayerOwner po = (PlayerOwner)owner;
            table.put("Player", po.player.getName(false));
        }
        return table;
    }

    @LuaFunction(mainThread=true)
    public String getOwnerName() throws LuaException {
        return ((TraderData)this.getTrader()).getOwner().getName().getString();
    }

    @LuaFunction(mainThread=true)
    public LCLuaTable getStats() throws LuaException {
        LCLuaTable table = new LCLuaTable();
        T trader = this.getTrader();
        for (String statKey : ((TraderData)trader).statTracker.getKeys()) {
            StatType.Instance<?, ?> entry = ((TraderData)trader).statTracker.getStat(statKey);
            if (entry == null) continue;
            Object display = entry.getDisplay();
            Object result = display.toString();
            if (display instanceof Component) {
                Component text = (Component)display;
                result = text.getString();
            }
            if (display instanceof Number || display instanceof Boolean) {
                result = display;
            }
            table.put(statKey, result);
        }
        return table;
    }

    @LuaFunction(mainThread=true)
    public String[] getAllies() throws LuaException {
        return (String[])((TraderData)this.getTrader()).getAllies().stream().map(p -> p.getName(false)).toArray(String[]::new);
    }

    @LuaFunction(mainThread=true)
    public LCLuaTable getAllyPermissions() throws LuaException {
        Object trader = this.getTrader();
        LCLuaTable table = new LCLuaTable();
        if (((TraderData)trader).isPersistent()) {
            return table;
        }
        ((TraderData)trader).getAllyPermissionMap().forEach((key, level) -> {
            if (!trader.getBlockedPermissions().contains(key)) {
                table.put(key, level);
            }
        });
        return table;
    }

    @LuaFunction(mainThread=true)
    public int getAllyPermissionLevel(String permission) throws LuaException {
        T trader = this.getTrader();
        if (((TraderData)trader).isPersistent() || ((TraderData)trader).getBlockedPermissions().contains(permission)) {
            return 0;
        }
        return ((TraderData)trader).getAllyPermissionMap().getOrDefault(permission, 0);
    }

    @LuaFunction(mainThread=true)
    public String[] getLogs(Object[] args) throws LuaException {
        Object filter = Predicates.alwaysTrue();
        int limit = 0;
        Tuple argsLoaded = new Tuple((Object)false, (Object)false);
        if (args.length > 0) {
            for (int i = 0; i < 2; ++i) {
                Object arg = args[i];
                if (arg instanceof Number) {
                    Number num = (Number)arg;
                    if (((Boolean)argsLoaded.m_14418_()).booleanValue()) {
                        throw LuaValues.badArgument((int)i, (String)"boolean", (String)"number");
                    }
                    limit = num.intValue();
                    argsLoaded.m_145023_((Object)true);
                    continue;
                }
                if (arg instanceof Boolean) {
                    Boolean boo = (Boolean)arg;
                    if (((Boolean)argsLoaded.m_14419_()).booleanValue()) {
                        throw LuaValues.badArgument((int)i, (String)"number", (String)"boolean");
                    }
                    filter = boo != false ? TraderData.LOGS_SETTINGS_FILTER : TraderData.LOGS_NORMAL_FILTER;
                    argsLoaded.m_145025_((Object)true);
                    continue;
                }
                throw LuaValues.badArgument((int)i, (String)"number or boolean", (String)arg.getClass().getSimpleName());
            }
        }
        List<Notification> notifications = ((TraderData)this.getTrader()).getNotifications((Predicate<Notification>)filter);
        if (limit <= 0) {
            limit = notifications.size();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < limit && i < notifications.size(); ++i) {
            Notification not = notifications.get(i);
            boolean first = true;
            for (MutableComponent line : not.getMessageLines()) {
                Object l = line.getString();
                if (first && not.getCount() > 1) {
                    l = "[" + not.getCount() + "] " + (String)l;
                }
                result.add((String)l);
                first = false;
            }
        }
        return (String[])result.toArray(String[]::new);
    }

    @LuaFunction(mainThread=true)
    public String getName() throws LuaException {
        return ((TraderData)this.getTrader()).getName().getString();
    }

    @LuaFunction(mainThread=true)
    public LCLuaTable getIcon() throws LuaException {
        T t = this.getTrader();
        return LCLuaTable.fromTag(((TraderData)t).getCustomIcon().save());
    }

    @LuaFunction(mainThread=true)
    public boolean hasBankAccount() throws LuaException {
        return ((TraderData)this.getTrader()).hasBankAccount();
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public LCLuaTable getLinkedAccount() throws LuaException {
        if (!this.hasBankAccount()) {
            return null;
        }
        BankReference br = ((TraderData)this.getTrader()).getBankReference();
        LCLuaTable table = LCLuaTable.fromTag(br.save());
        if (br instanceof PlayerBankReference) {
            PlayerBankReference pbr = (PlayerBankReference)br;
            table.put("Player", pbr.getPlayer().getName(false));
        }
        return table;
    }

    @LuaFunction(mainThread=true)
    public boolean showsSearchBox() throws LuaException {
        return ((TraderData)this.getTrader()).showSearchBox();
    }

    @LuaFunction(mainThread=true)
    public boolean hasPushNotifications() throws LuaException {
        return ((TraderData)this.getTrader()).notificationsEnabled();
    }

    @LuaFunction(mainThread=true)
    public boolean hasChatNotifications() throws LuaException {
        return ((TraderData)this.getTrader()).notificationsToChat();
    }

    @LuaFunction(mainThread=true)
    public int teamNotificationLevel() throws LuaException {
        return ((TraderData)this.getTrader()).teamNotificationLevel();
    }

    @LuaFunction(mainThread=true)
    public int tradeCount() throws LuaException {
        return ((TraderData)this.getTrader()).getTradeCount();
    }

    @LuaFunction(mainThread=true)
    public int validTradeCount() throws LuaException {
        return ((TraderData)this.getTrader()).validTradeCount();
    }

    @LuaFunction(mainThread=true)
    public int tradesWithStock() throws LuaException {
        return ((TraderData)this.getTrader()).tradesWithStock();
    }

    @LuaFunction(mainThread=true)
    public int acceptableTaxRate() throws LuaException {
        return ((TraderData)this.getTrader()).getAcceptableTaxRate();
    }

    @LuaFunction(mainThread=true)
    public int currentTaxRate() throws LuaException {
        return ((TraderData)this.getTrader()).getTotalTaxPercentage();
    }

    @LuaFunction(mainThread=true)
    public LCLuaTable getWorldPosition() throws LuaException {
        return LCLuaTable.fromTag(((TraderData)this.getTrader()).getWorldPosition().save());
    }

    @LuaFunction(mainThread=true)
    public String[] getCurrentUsers() throws LuaException {
        ArrayList<String> users = new ArrayList<String>();
        for (Player user : ((TraderData)this.getTrader()).getUsers()) {
            users.add(user.m_7755_().getString());
        }
        return (String[])users.toArray(String[]::new);
    }

    @LuaFunction(mainThread=true)
    public LCLuaTable[] getUpgradeItems() throws LuaException {
        ArrayList<LCLuaTable> list = new ArrayList<LCLuaTable>();
        Container upgrades = ((TraderData)this.getTrader()).getUpgrades();
        for (int i = 0; i < upgrades.m_6643_(); ++i) {
            list.add(LCLuaTable.fromTag(InventoryUtil.saveItemNoLimits(upgrades.m_8020_(i))));
        }
        return (LCLuaTable[])list.toArray(LCLuaTable[]::new);
    }

    private static class Simple
    extends TraderPeripheral<TraderBlockEntity<TraderData>, TraderData> {
        private Simple(TraderBlockEntity<TraderData> blockEntity) {
            super(blockEntity);
        }

        private Simple(TraderData trader) {
            super(trader);
        }

        public String getType() {
            return TraderPeripheral.BASE_TYPE;
        }

        @Override
        public Set<String> getAdditionalTypes() {
            return Set.of();
        }
    }
}

