/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.computercraft.data;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.LuaValues;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LCLuaTable
implements LuaTable<Object, Object> {
    private final Map<Object, Object> map;

    public LCLuaTable() {
        this.map = new HashMap<Object, Object>();
    }

    public LCLuaTable(Map<?, ?> map) {
        this.map = new HashMap(map);
    }

    public static LCLuaTable fromTag(CompoundTag compound) {
        LCLuaTable table = new LCLuaTable();
        for (String key : compound.m_128431_()) {
            Tag tag = compound.m_128423_(key);
            table.put(key, LCLuaTable.parseTag(compound.m_128423_(key)));
        }
        return table;
    }

    public static Object parseTag(Tag tag) {
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag t = (ByteArrayTag)tag;
            return t.m_128227_();
        }
        if (tag instanceof ByteTag) {
            ByteTag t = (ByteTag)tag;
            return t.m_7063_();
        }
        if (tag instanceof CompoundTag) {
            CompoundTag t = (CompoundTag)tag;
            return LCLuaTable.fromTag(t);
        }
        if (tag instanceof DoubleTag) {
            DoubleTag t = (DoubleTag)tag;
            return t.m_7061_();
        }
        if (tag instanceof FloatTag) {
            FloatTag t = (FloatTag)tag;
            return Float.valueOf(t.m_7057_());
        }
        if (tag instanceof IntArrayTag) {
            IntArrayTag t = (IntArrayTag)tag;
            return t.m_128648_();
        }
        if (tag instanceof IntTag) {
            IntTag t = (IntTag)tag;
            return t.m_7047_();
        }
        if (tag instanceof ListTag) {
            ListTag t = (ListTag)tag;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Tag value : t) {
                result.add(LCLuaTable.parseTag(value));
            }
            return result.toArray(Object[]::new);
        }
        if (tag instanceof LongArrayTag) {
            LongArrayTag t = (LongArrayTag)tag;
            return t.m_128851_();
        }
        if (tag instanceof LongTag) {
            LongTag t = (LongTag)tag;
            return t.m_7046_();
        }
        if (tag instanceof ShortTag) {
            ShortTag t = (ShortTag)tag;
            return t.m_7053_();
        }
        if (tag instanceof StringTag) {
            StringTag t = (StringTag)tag;
            return t.m_7916_();
        }
        return null;
    }

    public static LCLuaTable fromMoney(MoneyValue value) {
        LCLuaTable table = new LCLuaTable();
        table.put("numeric", value.getCoreValue());
        table.put("text", value.getText("Empty"));
        table.put("data", LCLuaTable.fromTag(value.save()));
        return table;
    }

    public boolean getBoolean(String key) throws LuaException {
        Object value = this.get(key);
        if (!(value instanceof Boolean)) {
            throw LuaValues.badField((String)key, (String)"boolean", (String)LuaValues.getType((Object)value));
        }
        return (Boolean)value;
    }

    public String getString(String key) throws LuaException {
        Object value = this.get(key);
        if (!(value instanceof String)) {
            throw LuaValues.badField((String)key, (String)"string", (String)LuaValues.getType((Object)value));
        }
        return (String)value;
    }

    public LCLuaTable getTable(String key) throws LuaException {
        Object value = this.get(key);
        if (!(value instanceof Map)) {
            throw LuaValues.badField((String)key, (String)"table", (String)LuaValues.getType((Object)value));
        }
        return new LCLuaTable((Map)value);
    }

    public Optional<Boolean> getOptBoolean(String key) throws LuaException {
        Object value = this.get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Boolean)) {
            throw LuaValues.badField((String)key, (String)"boolean", (String)LuaValues.getType((Object)value));
        }
        return Optional.of((Boolean)value);
    }

    public Set<String> stringKeySet() throws LuaException {
        HashSet<String> stringSet = new HashSet<String>();
        for (Object key : this.keySet()) {
            if (!(key instanceof String)) {
                throw new LuaException("key " + key + " is not string (got " + LuaValues.getType((Object)key) + ")");
            }
            stringSet.add((String)key);
        }
        return Collections.unmodifiableSet(stringSet);
    }

    public Collection<LCLuaTable> tableValues() throws LuaException {
        ArrayList<LCLuaTable> tables = new ArrayList<LCLuaTable>();
        for (int i = 1; i <= this.size(); ++i) {
            Object value = this.get(i);
            if (!(value instanceof Map)) {
                throw new LuaException("value " + value + " is not table (got " + LuaValues.getType((Object)value) + ")");
            }
            tables.add(new LCLuaTable((Map)value));
        }
        return Collections.unmodifiableList(tables);
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    @Nullable
    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.map.put(key, value);
    }

    public void putDouble(String key, double value) {
        this.map.put(key, value);
    }

    public void putString(String key, String value) {
        this.map.put(key, value);
    }

    public void putTable(String key, LCLuaTable value) {
        this.map.put(key, value);
    }

    public void putTable(int i, LCLuaTable value) {
        this.map.put(i, value);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object o) {
        return this.map.containsKey(o);
    }

    public boolean containsValue(Object o) {
        return this.map.containsValue(o);
    }

    public Object get(Object o) {
        return this.map.get(o);
    }

    @NotNull
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @NotNull
    public Collection<Object> values() {
        return this.map.values();
    }

    @NotNull
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }
}

