/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant.listings;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class EnchantedItemForCoinsTrade
implements VillagerTrades.ItemListing {
    public static final ResourceLocation TYPE = VersionUtil.lcResource("enchanted_item_for_coins");
    public static final Serializer SERIALIZER = new Serializer();
    protected final Item baseCoin;
    protected final int baseCoinCount;
    protected final Item sellItem;
    protected final int maxTrades;
    protected final int xp;
    protected final float priceMult;
    protected final double basePriceModifier;

    public EnchantedItemForCoinsTrade(ItemLike baseCoin, int baseCoinCount, ItemLike sellItem, int maxUses, int xpValue, float priceMultiplier, double basePriceModifier) {
        this.baseCoin = baseCoin.m_5456_();
        this.baseCoinCount = baseCoinCount;
        this.basePriceModifier = basePriceModifier;
        this.sellItem = sellItem.m_5456_();
        this.maxTrades = maxUses;
        this.xp = xpValue;
        this.priceMult = priceMultiplier;
    }

    public MerchantOffer m_213663_(@NotNull Entity trader, RandomSource rand) {
        int i = 5 + rand.m_188503_(15);
        ItemStack itemstack = EnchantmentHelper.m_220292_((RandomSource)rand, (ItemStack)new ItemStack((ItemLike)this.sellItem), (int)i, (boolean)false);
        ChainData chain = CoinAPI.API.ChainDataOfCoin(this.baseCoin);
        if (chain == null) {
            LightmansCurrency.LogWarning("Item for coin trade failed as '" + new ItemStack((ItemLike)this.baseCoin).m_41786_().getString() + "' is not a registered coin!");
            return null;
        }
        long coinValue = chain.getCoreValue(this.baseCoin);
        long baseValue = coinValue * (long)this.baseCoinCount;
        long priceValue = baseValue + (long)((double)(coinValue * (long)i) * this.basePriceModifier);
        ItemStack price1 = ItemStack.f_41583_;
        ItemStack price2 = ItemStack.f_41583_;
        MoneyValue v = CoinValue.fromNumber(chain.chain, priceValue);
        if (!(v instanceof CoinValue)) {
            return null;
        }
        CoinValue cv = (CoinValue)v;
        List<ItemStack> priceStacks = cv.getAsSeperatedItemList();
        if (!priceStacks.isEmpty()) {
            price1 = priceStacks.get(0);
        }
        if (priceStacks.size() > 1) {
            price2 = priceStacks.get(1);
        }
        LightmansCurrency.LogDebug("EnchantedItemForCoinsTrade.getOffer() -> \ni=" + i + "\ncoinValue=" + coinValue + "\nbaseValue=" + baseValue + "\npriceValue=" + priceValue + "\nprice1=" + price1.m_41613_() + "x" + ForgeRegistries.ITEMS.getKey((Object)price1.m_41720_()) + "\nprice2=" + price2.m_41613_() + "x" + ForgeRegistries.ITEMS.getKey((Object)price2.m_41720_()));
        return new MerchantOffer(price1, price2, itemstack, this.maxTrades, this.xp, this.priceMult);
    }

    public static class Serializer
    implements ItemListingSerializer.IItemListingSerializer,
    ItemListingSerializer.IItemListingDeserializer {
        private Serializer() {
        }

        @Override
        public ResourceLocation getType() {
            return TYPE;
        }

        @Override
        public JsonObject serializeInternal(JsonObject json, VillagerTrades.ItemListing trade) {
            if (trade instanceof EnchantedItemForCoinsTrade) {
                EnchantedItemForCoinsTrade t = (EnchantedItemForCoinsTrade)trade;
                json.addProperty("Coin", ForgeRegistries.ITEMS.getKey((Object)t.baseCoin).toString());
                json.addProperty("BaseCoinCount", (Number)t.baseCoinCount);
                json.addProperty("EnchantmentValueModifier", (Number)t.basePriceModifier);
                json.addProperty("Sell", ForgeRegistries.ITEMS.getKey((Object)t.sellItem).toString());
                json.addProperty("MaxTrades", (Number)t.maxTrades);
                json.addProperty("XP", (Number)t.xp);
                json.addProperty("PriceMult", (Number)Float.valueOf(t.priceMult));
                return json;
            }
            return null;
        }

        @Override
        public VillagerTrades.ItemListing deserialize(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
            Item coin = (Item)ForgeRegistries.ITEMS.getValue(VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"Coin")));
            int baseCoinCount = GsonHelper.m_13927_((JsonObject)json, (String)"BaseCoinCount");
            double basePriceModifier = GsonHelper.m_144784_((JsonObject)json, (String)"EnchantmentValueModifier");
            Item sellItem = (Item)ForgeRegistries.ITEMS.getValue(VersionUtil.parseResource(GsonHelper.m_13906_((JsonObject)json, (String)"Sell")));
            int maxTrades = GsonHelper.m_13927_((JsonObject)json, (String)"MaxTrades");
            int xp = GsonHelper.m_13927_((JsonObject)json, (String)"XP");
            float priceMult = GsonHelper.m_13915_((JsonObject)json, (String)"PriceMult");
            return new EnchantedItemForCoinsTrade((ItemLike)coin, baseCoinCount, (ItemLike)sellItem, maxTrades, xp, priceMult, basePriceModifier);
        }
    }
}

