/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.atm.ATMAPI;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest.ExchangeUpgradeTab;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class CoinChestExchangeUpgrade
extends CoinChestUpgrade {
    public static final int MAX_COMMANDS = 10;

    @Override
    public void HandleMenuMessage(@Nonnull CoinChestMenu menu, @Nonnull CoinChestUpgradeData data, @Nonnull LazyPacketData message) {
        if (message.contains("SetExchangeWhileOpen")) {
            this.setExchangeWhileOpen(data, message.getBoolean("SetExchangeWhileOpen"));
        }
        if (message.contains("ToggleExchangeCommand")) {
            String toggleCommand = message.getString("ToggleExchangeCommand");
            List<String> oldCommands = this.getExchangeCommands(data);
            if (oldCommands.contains(toggleCommand)) {
                this.removeExchangeCommand(data, toggleCommand);
            } else {
                this.addExchangeCommand(data, toggleCommand);
            }
        }
    }

    @Override
    public void OnStorageChanged(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        this.ExecuteExchangeCommand(be, data);
    }

    @Override
    public void OnEquip(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        this.ExecuteExchangeCommand(be, data);
    }

    public boolean getExchangeWhileOpen(CoinChestUpgradeData data) {
        CompoundTag compound = data.getItemTag();
        if (compound.m_128441_("ExchangeWhileOpen")) {
            return compound.m_128471_("ExchangeWhileOpen");
        }
        return true;
    }

    public void setExchangeWhileOpen(CoinChestUpgradeData data, boolean newValue) {
        CompoundTag compound = data.getItemTag();
        compound.m_128379_("ExchangeWhileOpen", newValue);
        data.setItemTag(compound);
    }

    public List<String> getExchangeCommands(CoinChestUpgradeData data) {
        CompoundTag compound = data.getItemTag();
        if (compound.m_128441_("ExchangeCommands")) {
            ListTag list = compound.m_128437_("ExchangeCommands", 8);
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                result.add(list.m_128778_(i));
            }
            return result;
        }
        if (compound.m_128441_("ExchangeCommand")) {
            return Lists.newArrayList((Object[])new String[]{compound.m_128461_("ExchangeCommand")});
        }
        return new ArrayList<String>();
    }

    public void addExchangeCommand(CoinChestUpgradeData data, String newValue) {
        CompoundTag compound = data.getItemTag();
        List<String> list = this.getExchangeCommands(data);
        if (list.contains(newValue) || newValue.isBlank() || list.size() >= 10) {
            return;
        }
        this.setExchangeCommands(compound, list);
        data.setItemTag(compound);
    }

    public void removeExchangeCommand(CoinChestUpgradeData data, String removedValue) {
        CompoundTag compound = data.getItemTag();
        List<String> list = this.getExchangeCommands(data);
        if (list.contains(removedValue)) {
            list.remove(removedValue);
            this.setExchangeCommands(compound, list);
            data.setItemTag(compound);
        }
    }

    private void setExchangeCommands(CompoundTag tag, List<String> commands) {
        ListTag list = new ListTag();
        for (String command : commands) {
            list.add((Object)StringTag.m_129297_((String)command));
        }
        tag.m_128365_("ExchangeCommands", (Tag)list);
        if (tag.m_128441_("ExchangeCommand")) {
            tag.m_128473_("ExchangeCommand");
        }
    }

    public void ExecuteExchangeCommand(CoinChestBlockEntity be, CoinChestUpgradeData data) {
        boolean executeWhileOpen = this.getExchangeWhileOpen(data);
        if (executeWhileOpen || be.getOpenerCount() <= 0) {
            List<String> commands = this.getExchangeCommands(data);
            for (String c : commands) {
                if (c == null || c.isBlank() || !ATMAPI.ExecuteATMExchangeCommand((Container)be.getStorage(), c)) continue;
                CoinAPI.API.SortCoinsByValue((Container)be.getStorage());
            }
        }
    }

    @Override
    public void addClientTabs(@Nonnull CoinChestUpgradeData data, @Nonnull Object screen, @Nonnull Consumer<Object> consumer) {
        consumer.accept(new ExchangeUpgradeTab(data, screen));
    }

    @Override
    @Nonnull
    public List<Component> getTooltip(@Nonnull UpgradeData data) {
        return Lists.newArrayList((Object[])new Component[]{LCText.TOOLTIP_UPGRADE_COIN_EXCHANGE.get(new Object[0])});
    }

    @Override
    public boolean clearDataFromStack(@Nonnull ItemStack stack) {
        return this.clearData(stack, "ExchangeCommand", "ExchangeWhileOpen");
    }
}

