/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.misc.QuarantineAPI;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest.BankUpgradeSelectTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.coin_chest.BankUpgradeSettingsTab;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.TickableCoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class CoinChestBankUpgrade
extends TickableCoinChestUpgrade {
    @Override
    public void HandleMenuMessage(@Nonnull CoinChestMenu menu, @Nonnull CoinChestUpgradeData data, @Nonnull LazyPacketData message) {
        if (message.contains("SetDepositMode")) {
            this.setDepositMode(data, message.getBoolean("SetDepositMode"));
        }
        if (message.contains("SetMoneyLimit")) {
            this.setMoneyLimit(data, message.getMoneyValue("SetMoneyLimit"));
        }
        if (message.contains("SetBankAccount")) {
            this.setSelectedBankAccount(data, menu.player, BankReference.load(message.getNBT("SetBankAccount")));
        }
        if (message.contains("CollectOverflowItems")) {
            this.clearOverflowItems(menu, data);
        }
    }

    public boolean isDepositMode(@Nonnull CoinChestUpgradeData data) {
        CompoundTag tag = data.getItemTag();
        if (tag.m_128441_("DepositMode")) {
            return tag.m_128471_("DepositMode");
        }
        return true;
    }

    public void setDepositMode(@Nonnull CoinChestUpgradeData data, boolean depositMode) {
        CompoundTag tag = data.getItemTag();
        tag.m_128379_("DepositMode", depositMode);
        data.setItemTag(tag);
    }

    @Nonnull
    public MoneyValue getMoneyLimit(@Nonnull CoinChestUpgradeData data) {
        CompoundTag tag = data.getItemTag();
        if (tag.m_128441_("MoneyLimit")) {
            return MoneyValue.safeLoad(tag, "MoneyLimit");
        }
        return MoneyValue.empty();
    }

    public void setMoneyLimit(@Nonnull CoinChestUpgradeData data, @Nonnull MoneyValue moneyLimit) {
        CompoundTag tag = data.getItemTag();
        tag.m_128365_("MoneyLimit", (Tag)moneyLimit.save());
        data.setItemTag(tag);
    }

    @Nullable
    public BankReference getTargetAccount(@Nonnull CoinChestUpgradeData data) {
        CompoundTag tag = data.getItemTag();
        if (tag.m_128441_("TargetAccount")) {
            return BankReference.load(tag.m_128469_("TargetAccount"));
        }
        return null;
    }

    private PlayerReference getPlayerContext(@Nonnull CoinChestUpgradeData data) {
        CompoundTag tag = data.getItemTag();
        if (tag.m_128441_("PlayerContext")) {
            return PlayerReference.load(tag.m_128469_("PlayerContext"));
        }
        return null;
    }

    @Nullable
    public IBankAccount getSelectedBankAccount(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        BankReference targetAccount = this.getTargetAccount(data);
        PlayerReference player = this.getPlayerContext(data);
        if (targetAccount != null && player != null && targetAccount.allowedAccess(player)) {
            return targetAccount.flagAsClient(be).get();
        }
        return null;
    }

    public void setSelectedBankAccount(@Nonnull CoinChestUpgradeData data, @Nonnull Player player, @Nonnull BankReference bankAccount) {
        CompoundTag tag = data.getItemTag();
        tag.m_128365_("TargetAccount", (Tag)bankAccount.save());
        tag.m_128365_("PlayerContext", (Tag)PlayerReference.of(player).save());
        data.setItemTag(tag);
    }

    @Nonnull
    public List<ItemStack> getOverflowItems(@Nonnull CoinChestUpgradeData data) {
        CompoundTag tag = data.getItemTag();
        if (tag.m_128441_("OverflowItems")) {
            return InventoryUtil.loadItemList("OverflowItems", tag);
        }
        return new ArrayList<ItemStack>();
    }

    private void setOverflowItems(@Nonnull CoinChestUpgradeData data, @Nonnull List<ItemStack> overflowItems) {
        CompoundTag tag = data.getItemTag();
        if (overflowItems.isEmpty()) {
            tag.m_128473_("OverflowItems");
        } else {
            InventoryUtil.saveItemList("OverflowItems", tag, overflowItems);
        }
        data.setItemTag(tag);
    }

    public void clearOverflowItems(@Nonnull CoinChestMenu menu, @Nonnull CoinChestUpgradeData data) {
        for (ItemStack item : this.getOverflowItems(data)) {
            ItemHandlerHelper.giveItemToPlayer((Player)menu.player, (ItemStack)item);
        }
        this.setOverflowItems(data, new ArrayList<ItemStack>());
    }

    @Override
    public int getTickFrequency() {
        return 100;
    }

    private boolean canInteract(CoinChestUpgradeData data) {
        BankReference targetAccount = this.getTargetAccount(data);
        PlayerReference player = this.getPlayerContext(data);
        List<ItemStack> overflowItems = this.getOverflowItems(data);
        return targetAccount != null && player != null && overflowItems.isEmpty();
    }

    @Override
    public void OnServerTick(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        if (QuarantineAPI.IsDimensionQuarantined(be)) {
            return;
        }
        if (this.canInteract(data)) {
            this.TryInteract(be, data);
        }
    }

    private void TryInteract(@Nonnull CoinChestBlockEntity be, @Nonnull CoinChestUpgradeData data) {
        BankReference br;
        BankReference targetAccount = this.getTargetAccount(data);
        PlayerReference player = this.getPlayerContext(data);
        List<ItemStack> overflowItems = this.getOverflowItems(data);
        if (targetAccount != null && player != null && overflowItems.isEmpty() && (br = targetAccount.flagAsClient(be)).allowedAccess(player)) {
            MoneyValue taken;
            MoneyValue result;
            MoneyValue available;
            MoneyValue targetToTake;
            IBankAccount account = br.get();
            if (account == null) {
                return;
            }
            boolean depositMode = this.isDepositMode(data);
            MoneyValue moneyLimit = this.getMoneyLimit(data);
            overflowItems = new ArrayList<ItemStack>();
            IMoneyHandler handler = MoneyAPI.API.GetContainersMoneyHandler((Container)be.getStorage(), overflowItems::add, be);
            MoneyView contents = handler.getStoredMoney();
            if (depositMode && contents.containsValue(moneyLimit)) {
                for (MoneyValue value : contents.allValues()) {
                    MoneyValue result2;
                    MoneyValue takenAmount;
                    if (!value.sameType(moneyLimit) || handler.extractMoney(value, true).getCoreValue() >= value.getCoreValue() || (takenAmount = value.subtractValue(result2 = handler.extractMoney(value, false))).isEmpty()) continue;
                    account.depositMoney(takenAmount);
                }
            }
            if (!(depositMode || contents.containsValue(moneyLimit) || (targetToTake = moneyLimit.subtractValue(available = contents.valueOf(moneyLimit.getUniqueName()))).isEmpty() || (result = handler.insertMoney(taken = account.withdrawMoney(targetToTake), false)).isEmpty())) {
                account.depositMoney(result);
            }
            if (!overflowItems.isEmpty()) {
                this.setOverflowItems(data, overflowItems);
            }
        }
    }

    @Override
    public void addClientTabs(@Nonnull CoinChestUpgradeData data, @Nonnull Object screen, @Nonnull Consumer<Object> consumer) {
        consumer.accept(new BankUpgradeSelectTab(data, screen));
        consumer.accept(new BankUpgradeSettingsTab(data, screen));
    }

    @Override
    @Nonnull
    public List<Component> getTooltip(@Nonnull UpgradeData data) {
        return Lists.newArrayList((Object[])new Component[]{LCText.TOOLTIP_UPGRADE_BANK.get(new Object[0])});
    }

    @Override
    public boolean clearDataFromStack(@Nonnull ItemStack stack) {
        return this.clearData(stack, "DepositMode", "MoneyLimit", "TargetAccount", "PlayerContext", "OverflowItems");
    }
}

