/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.slot_machine;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.coins.data.ChainData;
import io.github.lightman314.lightmanscurrency.api.money.value.IItemBasedValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public final class SlotMachineEntry {
    public static final int ITEM_LIMIT = 4;
    public final List<ItemStack> items;
    private int weight;

    public void TryAddItem(ItemStack item) {
        if (this.items.size() >= 4 || item.m_41619_()) {
            return;
        }
        this.items.add(item);
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int newWeight) {
        this.weight = Math.max(1, newWeight);
    }

    private SlotMachineEntry(List<ItemStack> items, int weight) {
        this.items = InventoryUtil.copyList(items);
        this.setWeight(weight);
    }

    public boolean isValid() {
        return !this.items.isEmpty() && this.weight > 0;
    }

    public boolean isMoney() {
        if (this.items.isEmpty()) {
            return false;
        }
        ChainData chain = null;
        for (ItemStack item : this.items) {
            if (CoinAPI.API.IsCoin(item, false)) {
                if (chain == null) {
                    chain = CoinAPI.API.ChainDataOfCoin(item);
                    continue;
                }
                if (chain == CoinAPI.API.ChainDataOfCoin(item)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public MoneyValue getMoneyValue() {
        if (!this.isMoney()) {
            return MoneyValue.empty();
        }
        ChainData chain = null;
        long value = 0L;
        for (ItemStack item : this.items) {
            if (CoinAPI.API.IsCoin(item, false)) {
                if (chain == null) {
                    chain = CoinAPI.API.ChainDataOfCoin(item);
                } else if (chain != CoinAPI.API.ChainDataOfCoin(item)) {
                    return MoneyValue.empty();
                }
                value += chain.getCoreValue(item) * (long)item.m_41613_();
                continue;
            }
            if (item.m_41619_()) continue;
            return MoneyValue.empty();
        }
        if (chain == null) {
            return MoneyValue.empty();
        }
        return CoinValue.fromNumber(chain.chain, value);
    }

    public void validateItems() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).m_41619_()) continue;
            this.items.remove(i--);
        }
    }

    public List<ItemStack> getDisplayItems() {
        MoneyValue value;
        if (this.isMoney() && (value = this.getMoneyValue()) instanceof IItemBasedValue) {
            IItemBasedValue itemValue = (IItemBasedValue)((Object)value);
            return itemValue.getAsSeperatedItemList();
        }
        return InventoryUtil.copyList(this.items);
    }

    @Nonnull
    public static List<ItemStack> splitDisplayItems(@Nonnull List<ItemStack> displayItems) {
        if (displayItems.size() >= 4) {
            return displayItems;
        }
        int totalCount = 0;
        for (ItemStack s : displayItems) {
            totalCount += s.m_41613_();
        }
        List<ItemStack> result = InventoryUtil.copyList(displayItems);
        Random random = new Random();
        while (result.size() < 4 && result.size() < totalCount) {
            int splitIndex = random.nextInt(result.size());
            ItemStack s = result.get(splitIndex);
            if (s.m_41613_() <= 1) continue;
            int splitCount = s.m_41613_() / 2;
            ItemStack split = s.m_41620_(splitCount);
            result.add(split);
        }
        return result;
    }

    public boolean CanGiveToCustomer(TradeContext context) {
        if (this.isMoney()) {
            return context.hasPaymentMethod();
        }
        return context.canFitItems(this.items);
    }

    public boolean GiveToCustomer(SlotMachineTraderData trader, TradeContext context) {
        if (this.hasStock(trader)) {
            if (this.isMoney()) {
                MoneyValue reward = this.getMoneyValue();
                if (!context.givePayment(reward)) {
                    return false;
                }
                if (!trader.isCreative()) {
                    trader.removeStoredMoney(reward, false);
                }
            } else {
                for (int i = 0; i < this.items.size(); ++i) {
                    if (context.putItem(this.items.get(i).m_41777_())) continue;
                    for (int x = 0; x < i; ++x) {
                        context.collectItem(this.items.get(x).m_41777_());
                    }
                    return false;
                }
                if (!trader.isCreative()) {
                    for (ItemStack i : this.items) {
                        trader.getStorage().removeItem(i);
                    }
                    trader.markStorageDirty();
                }
            }
            return true;
        }
        return false;
    }

    public int getStock(SlotMachineTraderData trader) {
        if (!this.isValid()) {
            return 0;
        }
        if (trader.isCreative()) {
            return 1;
        }
        if (this.isMoney()) {
            MoneyValue payout = this.getMoneyValue();
            if (payout.isEmpty() || payout.getCoreValue() <= 0L) {
                return 0;
            }
            IMoneyHolder storedMoney = trader.getStoredMoney();
            MoneyValue totalMoney = storedMoney.getStoredMoney().valueOf(payout.getUniqueName());
            return (int)(totalMoney.getCoreValue() / payout.getCoreValue());
        }
        int minStock = Integer.MAX_VALUE;
        for (ItemStack item : InventoryUtil.combineQueryItems(this.items)) {
            int count = trader.getStorage().getItemCount(item);
            int stock = count / item.m_41613_();
            if (stock >= minStock) continue;
            minStock = stock;
        }
        return minStock;
    }

    public boolean hasStock(SlotMachineTraderData trader) {
        return this.getStock(trader) > 0;
    }

    public boolean isItemRelevant(ItemStack item) {
        if (this.isMoney()) {
            return false;
        }
        return this.items.stream().anyMatch(i -> InventoryUtil.ItemMatches(i, item));
    }

    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        ListTag itemList = new ListTag();
        for (ItemStack item : this.items) {
            itemList.add((Object)item.m_41739_(new CompoundTag()));
        }
        compound.m_128365_("Items", (Tag)itemList);
        compound.m_128405_("Weight", this.weight);
        return compound;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonArray itemList = new JsonArray();
        for (ItemStack item : this.items) {
            itemList.add((JsonElement)FileUtil.convertItemStack(item));
        }
        json.add("Items", (JsonElement)itemList);
        json.addProperty("Weight", (Number)this.weight);
        return json;
    }

    public static SlotMachineEntry create() {
        return new SlotMachineEntry(new ArrayList<ItemStack>(), 1);
    }

    public static SlotMachineEntry load(CompoundTag compound) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (compound.m_128441_("Items")) {
            ListTag itemList = compound.m_128437_("Items", 10);
            for (int i = 0; i < itemList.size(); ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i));
                if (stack.m_41619_()) continue;
                items.add(stack);
            }
        }
        if (compound.m_128441_("Weight")) {
            return new SlotMachineEntry(items, compound.m_128451_("Weight"));
        }
        return new SlotMachineEntry(items, 1);
    }

    public static SlotMachineEntry parse(JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        JsonArray itemList = GsonHelper.m_13933_((JsonObject)json, (String)"Items");
        for (int i = 0; i < itemList.size(); ++i) {
            try {
                ItemStack stack = FileUtil.parseItemStack(itemList.get(i).getAsJsonObject());
                if (stack.m_41619_()) {
                    throw new JsonSyntaxException("Cannot add an empty item to a Slot Machine Entry!");
                }
                items.add(stack);
                continue;
            }
            catch (JsonSyntaxException | ResourceLocationException t) {
                LightmansCurrency.LogError("Error parsing Slot Machine Entry item #" + (i + 1), t);
            }
        }
        if (items.isEmpty()) {
            throw new JsonSyntaxException("Slot Machine Entry has no valid items!");
        }
        int weight = GsonHelper.m_13824_((JsonObject)json, (String)"Weight", (int)1);
        return new SlotMachineEntry(items, weight);
    }
}

