/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.settings.data.SavedSettingData;
import io.github.lightman314.lightmanscurrency.api.traders.rules.ICopySupportingRule;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.PriceFluctuationTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.PriceTweakingTradeRule;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PriceFluctuation
extends PriceTweakingTradeRule
implements ICopySupportingRule {
    public static final TradeRuleType<PriceFluctuation> TYPE = new TradeRuleType(VersionUtil.lcResource("price_fluctuation"), PriceFluctuation::new);
    long duration = 86400000L;
    int fluctuation = 10;
    private static final List<Long> debuggedSeeds = new ArrayList<Long>();
    private static final List<Long> debuggedTraderFactors = new ArrayList<Long>();

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = MathUtil.clamp(duration, 60000L, Long.MAX_VALUE);
    }

    public int getFluctuation() {
        return this.fluctuation;
    }

    public void setFluctuation(int fluctuation) {
        this.fluctuation = MathUtil.clamp(fluctuation, 1, 100);
    }

    public PriceFluctuation() {
        super(TYPE);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_PRICE_FLUCTUATION;
    }

    private static void debugTraderFactor(long factor, long traderID, int tradeIndex) {
        if (debuggedTraderFactors.contains(factor)) {
            return;
        }
        LightmansCurrency.LogDebug("Trader Seed Factor for trader with id '" + traderID + "' and trade index '" + tradeIndex + "' is " + factor);
        debuggedTraderFactors.add(factor);
    }

    private static void debugFlux(long seed, int maxFlux, int flux) {
        if (debuggedSeeds.contains(seed)) {
            return;
        }
        LightmansCurrency.LogDebug("Price Fluctuation for trade with seed '" + seed + "' and max fluctuation of " + maxFlux + "% is " + flux + "%");
        debuggedSeeds.add(seed);
    }

    private long getTraderSeedFactor(TradeEvent.TradeCostEvent event) {
        long traderID = event.getTrader().getID();
        int tradeIndex = event.getTradeIndex();
        long factor = (traderID + 1L << 32) + (long)tradeIndex;
        PriceFluctuation.debugTraderFactor(factor, traderID, tradeIndex);
        return factor;
    }

    private int randomizePriceMultiplier(long traderSeedFactor) {
        long seed = TimeUtil.getCurrentTime() / this.duration;
        int fluct = new Random(seed * traderSeedFactor).nextInt(-this.fluctuation, this.fluctuation + 1);
        PriceFluctuation.debugFlux(seed * traderSeedFactor, this.fluctuation, fluct);
        return fluct;
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        event.giveDiscount(this.randomizePriceMultiplier(this.getTraderSeedFactor(event)));
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128356_("Duration", this.duration);
        compound.m_128405_("Fluctuation", this.fluctuation);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.duration = compound.m_128454_("Duration");
        if (this.duration <= 0L) {
            this.duration = 86400000L;
        }
        this.fluctuation = compound.m_128451_("Fluctuation");
    }

    @Override
    public void writeSettings(SavedSettingData.MutableNodeAccess node) {
        node.setIntValue("fluctuation", this.fluctuation);
        node.setLongValue("duration", this.duration);
    }

    @Override
    public void loadSettings(SavedSettingData.NodeAccess node) {
        this.fluctuation = Math.max(1, node.getIntValue("fluctuation"));
        this.duration = Math.max(60000L, node.getLongValue("duration"));
    }

    @Override
    public void resetToDefaultState() {
        this.fluctuation = 10;
        this.duration = 86400000L;
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("Duration", (Number)this.duration);
        json.addProperty("Fluctuation", (Number)this.fluctuation);
        return json;
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Duration")) {
            this.duration = GsonHelper.m_13921_((JsonObject)json, (String)"Duration");
        }
        if (json.has("Fluctuation")) {
            this.fluctuation = GsonHelper.m_13927_((JsonObject)json, (String)"Fluctuation");
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        return null;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
    }

    @Override
    protected void handleUpdateMessage(Player player, LazyPacketData updateInfo) {
        if (updateInfo.contains("Duration")) {
            this.setDuration(updateInfo.getLong("Duration"));
        }
        if (updateInfo.contains("Fluctuation")) {
            this.setFluctuation(updateInfo.getInt("Fluctuation"));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new PriceFluctuationTab(parent);
    }
}

