/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.ticket.TicketKioskRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.BookRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.EquipmentRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.ItemRequirement;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemTradeRestriction {
    public static final ResourceLocation NO_RESTRICTION_KEY = VersionUtil.lcResource("none");
    private static final Map<ResourceLocation, ItemTradeRestriction> registeredRestrictions = new HashMap<ResourceLocation, ItemTradeRestriction>();
    public static final ItemTradeRestriction NONE = new ItemTradeRestriction();

    public static void init() {
        ItemTradeRestriction.register(NO_RESTRICTION_KEY, NONE);
        ItemTradeRestriction.register("equipment_head", (ItemTradeRestriction)EquipmentRestriction.HEAD);
        ItemTradeRestriction.register("equipment_chest", (ItemTradeRestriction)EquipmentRestriction.CHEST);
        ItemTradeRestriction.register("equipment_legs", (ItemTradeRestriction)EquipmentRestriction.LEGS);
        ItemTradeRestriction.register("equipment_feet", (ItemTradeRestriction)EquipmentRestriction.FEET);
        ItemTradeRestriction.register("ticket_kiosk", (ItemTradeRestriction)TicketKioskRestriction.REGISTERED_INSTANCE);
        ItemTradeRestriction.register("book", (ItemTradeRestriction)BookRestriction.INSTANCE);
    }

    private static void register(String type, ItemTradeRestriction restriction) {
        ItemTradeRestriction.register(VersionUtil.lcResource(type), restriction);
    }

    public static void register(ResourceLocation type, ItemTradeRestriction restriction) {
        if (registeredRestrictions.containsKey(type)) {
            LightmansCurrency.LogWarning("Cannot register an Item Trade Restriction of type '" + type + "' as one is already registered.");
            return;
        }
        registeredRestrictions.put(type, restriction);
    }

    public static ResourceLocation getId(ItemTradeRestriction restriction) {
        if (restriction == null || !registeredRestrictions.containsValue(restriction)) {
            return NO_RESTRICTION_KEY;
        }
        AtomicReference<ResourceLocation> result = new AtomicReference<ResourceLocation>(NO_RESTRICTION_KEY);
        registeredRestrictions.forEach((type, r) -> {
            if (r == restriction) {
                result.set((ResourceLocation)type);
            }
        });
        return result.get();
    }

    public static void forEach(BiConsumer<ResourceLocation, ItemTradeRestriction> consumer) {
        registeredRestrictions.forEach(consumer);
    }

    public ResourceLocation getType() {
        return ItemTradeRestriction.getId(this);
    }

    protected ItemTradeRestriction() {
    }

    public ItemStack modifySellItem(ItemStack sellItem, String customName, ItemTradeData trade, int index) {
        return sellItem;
    }

    public boolean displayCustomName(ItemStack sellItem, ItemTradeData trade, int index) {
        return true;
    }

    public boolean allowSellItem(ItemStack itemStack) {
        return true;
    }

    public ItemStack filterSellItem(ItemStack itemStack) {
        return itemStack;
    }

    public boolean allowItemSelectItem(ItemStack itemStack) {
        return true;
    }

    public boolean allowExtraItemInStorage(ItemStack itemStack) {
        return false;
    }

    public int getSaleStock(TraderItemStorage traderStorage, ItemTradeData trade) {
        int minStock = Integer.MAX_VALUE;
        for (ItemRequirement requirement : InventoryUtil.combineRequirements(trade.getItemRequirement(0), trade.getItemRequirement(1))) {
            minStock = Math.min(this.getItemStock(requirement, traderStorage), minStock);
        }
        return minStock;
    }

    public List<ItemStack> getRandomSellItems(ItemTraderData trader, ItemTradeData trade) {
        if (this.alwaysEnforceNBT(0) && this.alwaysEnforceNBT(1)) {
            return this.getNBTEnforcedSellItems(trade);
        }
        List<ItemStack> randomItems = ItemRequirement.getRandomItemsMatchingRequirements(trader.getStorage(), trade.getItemRequirement(0), trade.getItemRequirement(1));
        if (randomItems == null && trader.isCreative()) {
            return this.getNBTEnforcedSellItems(trade);
        }
        return randomItems;
    }

    protected final List<ItemStack> getNBTEnforcedSellItems(ItemTradeData trade) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (int i = 0; i < 2; ++i) {
            ItemStack stack = trade.getSellItem(i);
            if (stack.m_41619_()) continue;
            results.add(stack);
        }
        return results;
    }

    protected final int getItemStock(ItemRequirement requirement, TraderItemStorage traderStorage) {
        if (requirement.isNull() || requirement.getCount() == 0) {
            return Integer.MAX_VALUE;
        }
        return traderStorage.getItemCount(requirement) / requirement.getCount();
    }

    protected final int getItemStock(ItemStack sellItem, TraderItemStorage traderStorage) {
        if (sellItem.m_41619_()) {
            return Integer.MAX_VALUE;
        }
        return traderStorage.getItemCount(sellItem) / sellItem.m_41613_();
    }

    public void removeItemsFromStorage(TraderItemStorage traderStorage, List<ItemStack> soldItems) {
        for (ItemStack sellItem : soldItems) {
            this.removeFromStorage(sellItem, traderStorage);
        }
    }

    protected final void removeFromStorage(ItemStack sellItem, TraderItemStorage traderStorage) {
        if (sellItem.m_41619_()) {
            return;
        }
        traderStorage.removeItem(sellItem);
    }

    public boolean alwaysEnforceNBT(int tradeSlot) {
        return false;
    }

    public Pair<ResourceLocation, ResourceLocation> getEmptySlotBG() {
        return EasySlot.BACKGROUND;
    }
}

