/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.text;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.level.ItemLike;

public final class CombinedTextEntry {
    private final List<Supplier<String>> keys;

    public void forEachKey(@Nonnull Consumer<String> consumer) {
        this.keys.forEach(s -> consumer.accept((String)s.get()));
    }

    public CombinedTextEntry(@Nonnull List<Supplier<String>> keys) {
        this.keys = ImmutableList.copyOf(keys);
    }

    @SafeVarargs
    public static CombinedTextEntry items(Supplier<? extends ItemLike> ... items) {
        ArrayList<Supplier<String>> list = new ArrayList<Supplier<String>>();
        for (Supplier<? extends ItemLike> item : items) {
            list.add(() -> ((ItemLike)item.get()).m_5456_().m_5524_());
        }
        return new CombinedTextEntry(list);
    }
}

