/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.settings;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.PlayerOwner;
import io.github.lightman314.lightmanscurrency.api.ownership.builtin.TeamOwner;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;

public class ChangeOwnerNotification
extends SingleLineNotification {
    public static final NotificationType<ChangeOwnerNotification> TYPE = new NotificationType(VersionUtil.lcResource("change_ownership"), ChangeOwnerNotification::new);
    PlayerReference player;
    Owner newOwner;
    Owner oldOwner;

    private ChangeOwnerNotification() {
    }

    public ChangeOwnerNotification(@Nonnull PlayerReference player, @Nonnull Owner newOwner, @Nonnull Owner oldOwner) {
        this.player = player;
        this.newOwner = newOwner.copy();
        this.newOwner.setParent(this);
        this.oldOwner = oldOwner.copy();
        this.oldOwner.setParent(this);
    }

    @Nonnull
    protected NotificationType<ChangeOwnerNotification> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        if (this.newOwner.asPlayerReference().isExact(this.player)) {
            return LCText.NOTIFICATION_SETTINGS_CHANGE_OWNER_TAKEN.get(this.newOwner.getName(), this.oldOwner.getName());
        }
        if (this.oldOwner.asPlayerReference().isExact(this.player)) {
            return LCText.NOTIFICATION_SETTINGS_CHANGE_OWNER_PASSED.get(this.oldOwner.getName(), this.newOwner.getName());
        }
        return LCText.NOTIFICATION_SETTINGS_CHANGE_OWNER_TRANSFERRED.get(this.player.getName(true), this.oldOwner.getName(), this.newOwner.getName());
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128365_("Player", (Tag)this.player.save());
        compound.m_128365_("NewOwner", (Tag)this.newOwner.save());
        compound.m_128365_("OldOwner", (Tag)this.oldOwner.save());
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.player = PlayerReference.load(compound.m_128469_("Player"));
        this.newOwner = ChangeOwnerNotification.safeLoad(compound.m_128469_("NewOwner"));
        this.newOwner.setParent(this);
        this.oldOwner = ChangeOwnerNotification.safeLoad(compound.m_128469_("OldOwner"));
        this.oldOwner.setParent(this);
    }

    @Nonnull
    private static Owner safeLoad(@Nonnull CompoundTag tag) {
        PlayerReference pr;
        if (tag.m_128441_("Type")) {
            Owner o = Owner.load(tag);
            return o != null ? o : Owner.getNull();
        }
        if (tag.m_128441_("Player") && (pr = PlayerReference.load(tag.m_128469_("Player"))) != null) {
            return PlayerOwner.of(pr);
        }
        if (tag.m_128441_("Team")) {
            long teamID = tag.m_128454_("Team");
            return TeamOwner.of(teamID);
        }
        return Owner.getNull();
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        if (other instanceof ChangeOwnerNotification) {
            ChangeOwnerNotification n = (ChangeOwnerNotification)other;
            return n.player.is(this.player) && n.newOwner.matches(this.newOwner) && n.oldOwner.matches(this.oldOwner);
        }
        return false;
    }
}

