/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.ejection;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.api.notifications.SingleLineNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class OwnableBlockEjectedNotification
extends SingleLineNotification {
    public static final NotificationType<OwnableBlockEjectedNotification> TYPE = new NotificationType(VersionUtil.lcResource("block_ejected"), OwnableBlockEjectedNotification::new);
    private Component name = EasyText.empty();
    private boolean ejected = false;
    private boolean anarchy = false;

    private OwnableBlockEjectedNotification() {
    }

    public OwnableBlockEjectedNotification(@Nonnull Component name) {
        this.name = name.m_6881_();
        this.ejected = (Boolean)LCConfig.SERVER.safelyEjectMachineContents.get();
        this.anarchy = (Boolean)LCConfig.SERVER.anarchyMode.get();
    }

    @Nonnull
    public static Supplier<Notification> create(@Nonnull Component name) {
        return () -> new OwnableBlockEjectedNotification(name);
    }

    @Override
    @Nonnull
    protected NotificationType<?> getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    @Nonnull
    public MutableComponent getMessage() {
        return this.getText().get(this.name);
    }

    private TextEntry getText() {
        if (this.anarchy) {
            return LCText.NOTIFICATION_EJECTION_ANARCHY;
        }
        if (this.ejected) {
            return LCText.NOTIFICATION_EJECTION_EJECTED;
        }
        return LCText.NOTIFICATION_EJECTION_DROPPED;
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound) {
        compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.name));
        if (this.ejected) {
            compound.m_128379_("Ejected", this.ejected);
        }
        if (this.anarchy) {
            compound.m_128379_("Anarchy", this.anarchy);
        }
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound) {
        this.name = Component.Serializer.m_130701_((String)compound.m_128461_("Name"));
        if (compound.m_128441_("Ejected")) {
            this.ejected = compound.m_128471_("Ejected");
        }
        if (compound.m_128441_("Anarchy")) {
            this.anarchy = compound.m_128471_("Anarchy");
        }
    }

    @Override
    protected boolean canMerge(@Nonnull Notification other) {
        return false;
    }
}

