/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core;

import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TradeRulesTab
extends TraderStorageTab {
    @Nullable
    public abstract ITradeRuleHost getHost();

    protected TradeRulesTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    public boolean canOpen(Player player) {
        return ((ITraderStorageMenu)this.menu).hasPermission("editTradeRules");
    }

    public void EditTradeRule(@Nonnull TradeRuleType<?> type, @Nonnull LazyPacketData.Builder updateMessage) {
        this.EditTradeRule(type.type, updateMessage);
    }

    public void EditTradeRule(@Nonnull ResourceLocation type, @Nonnull LazyPacketData.Builder updateMessage) {
        if (!((ITraderStorageMenu)this.menu).hasPermission("editTradeRules")) {
            return;
        }
        ITradeRuleHost host = this.getHost();
        if (host != null) {
            host.HandleRuleUpdate(((ITraderStorageMenu)this.menu).getPlayer(), type, updateMessage.build());
        }
        if (((ITraderStorageMenu)this.menu).isClient()) {
            ((ITraderStorageMenu)this.menu).SendMessage(updateMessage.setString("TradeRuleEdit", type.toString()));
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("TradeRuleEdit")) {
            ResourceLocation type = VersionUtil.parseResource(message.getString("TradeRuleEdit"));
            this.EditTradeRule(type, message.copyToBuilder());
        }
    }

    public boolean hasBackButton() {
        return false;
    }

    public void goBack() {
    }

    public static class Trade
    extends TradeRulesTab {
        private int tradeIndex = -1;

        public int getTradeIndex() {
            return this.tradeIndex;
        }

        public Trade(TraderStorageMenu menu) {
            super(menu);
        }

        @Override
        @Nonnull
        @OnlyIn(value=Dist.CLIENT)
        public Object createClientTab(@Nonnull Object screen) {
            return new TradeRulesClientTab.Trade(screen, this);
        }

        @Override
        public boolean canOpen(Player player) {
            return super.canOpen(player) && ((ITraderStorageMenu)this.menu).hasPermission("editTrades");
        }

        @Override
        public boolean hasBackButton() {
            return true;
        }

        @Override
        public void goBack() {
            ((ITraderStorageMenu)this.menu).ChangeTab(2, this.builder().setInt("TradeIndex", this.tradeIndex));
        }

        @Override
        @Nullable
        public ITradeRuleHost getHost() {
            TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
            if (trader != null) {
                return trader.getTrade(this.tradeIndex);
            }
            return null;
        }

        @Override
        public void OpenMessage(LazyPacketData message) {
            if (message.contains("TradeIndex")) {
                this.tradeIndex = message.getInt("TradeIndex");
            }
        }
    }

    public static class Trader
    extends TradeRulesTab {
        public Trader(TraderStorageMenu menu) {
            super(menu);
        }

        @Override
        @Nonnull
        @OnlyIn(value=Dist.CLIENT)
        public Object createClientTab(@Nonnull Object screen) {
            return new TradeRulesClientTab.Trader(screen, this);
        }

        @Override
        @Nullable
        public ITradeRuleHost getHost() {
            return ((ITraderStorageMenu)this.menu).getTrader();
        }
    }
}

