/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.api.misc.QuarantineAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.items.cards.ATMCardItem;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.menus.slots.DisplaySlot;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class ATMCardMenu
extends LazyMessageMenu {
    private final int inventorySlot;

    public ATMCardMenu(int id, Inventory inventory, int inventorySlot) {
        super(ModMenus.ATM_CARD.get(), id, inventory);
        this.addValidator(this::isBankCardValid);
        this.addValidator((Player player) -> !this.getAccountLocked() || LCAdminMode.isAdminPlayer(player));
        this.addValidator((Player player) -> !QuarantineAPI.IsDimensionQuarantined((Entity)player));
        this.inventorySlot = inventorySlot;
        this.m_38897_(new DisplaySlot((Container)inventory, inventorySlot, 6, 6));
    }

    private boolean isBankCardValid() {
        return this.getBankCard().m_41720_() instanceof ATMCardItem;
    }

    @Nonnull
    protected final ItemStack getBankCard() {
        return this.inventory.m_8020_(this.inventorySlot);
    }

    @Nullable
    public BankReference getSelectedAccount() {
        CompoundTag tag = this.getBankCard().m_41784_();
        if (tag.m_128441_("BankAccount")) {
            return BankReference.load(tag.m_128469_("BankAccount")).flagAsClient(this);
        }
        return null;
    }

    public void setSelectedAccount(@Nullable BankReference reference) {
        ItemStack card = this.getBankCard();
        if (card.m_41720_() instanceof ATMCardItem) {
            CompoundTag tag = card.m_41784_();
            if (reference != null) {
                IBankAccount account = reference.flagAsClient(this).get();
                if (account != null && reference.allowedAccess(this.player)) {
                    tag.m_128365_("BankAccount", (Tag)reference.save());
                    tag.m_128405_("AccountValidation", account.getCardValidation());
                }
            } else {
                tag.m_128473_("BankAccount");
                tag.m_128473_("AccountValidation");
            }
        }
        if (this.isClient()) {
            if (reference == null) {
                this.SendMessage(this.builder().setFlag("SelectEmptyAccount"));
            } else {
                this.SendMessage(this.builder().setCompound("SelectAccount", reference.save()));
            }
        }
    }

    public int getAccountValidation() {
        CompoundTag tag = this.getBankCard().m_41784_();
        return tag.m_128441_("AccountValidation") ? tag.m_128451_("AccountValidation") : -1;
    }

    public boolean isAccountValid() {
        IBankAccount account;
        BankReference br = this.getSelectedAccount();
        int validation = this.getAccountValidation();
        if (br != null && (account = br.get()) != null) {
            return account.isCardValid(validation);
        }
        return false;
    }

    public boolean getAccountLocked() {
        CompoundTag tag = this.getBankCard().m_41784_();
        return tag.m_128471_("CardLocked");
    }

    public void setAccountLocked(boolean locked) {
        ItemStack card = this.getBankCard();
        if (card.m_41720_() instanceof ATMCardItem) {
            CompoundTag tag = card.m_41784_();
            if (!locked) {
                tag.m_128473_("CardLocked");
            } else if (tag.m_128441_("BankAccount")) {
                tag.m_128379_("CardLocked", true);
            }
        }
        if (this.isClient()) {
            this.SendMessage(this.builder().setBoolean("SetLocked", locked));
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int slot) {
        return ItemStack.f_41583_;
    }

    @Override
    public void HandleMessage(@Nonnull LazyPacketData message) {
        if (message.contains("SelectEmptyAccount")) {
            this.setSelectedAccount(null);
        }
        if (message.contains("SelectAccount")) {
            this.setSelectedAccount(BankReference.load(message.getNBT("SelectAccount")));
        }
        if (message.contains("SetLocked")) {
            this.setAccountLocked(message.getBoolean("SetLocked"));
        }
    }

    @Nonnull
    public static MenuProvider getProvider(int inventorySlot) {
        return new Provider(inventorySlot);
    }

    private record Provider(int inventorySlot) implements EasyMenuProvider
    {
        @Nullable
        public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new ATMCardMenu(id, inventory, this.inventorySlot);
        }
    }
}

