/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.LCText;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ChocolateCoinItem
extends Item {
    private final List<MobEffectInstance> effects;
    private final float healing;

    public ChocolateCoinItem(MobEffectInstance ... effects) {
        this(0.0f, effects);
    }

    public ChocolateCoinItem(float healing, MobEffectInstance ... effects) {
        this(new Item.Properties(), healing, effects);
    }

    public ChocolateCoinItem(Item.Properties properties, MobEffectInstance ... effects) {
        this(properties, 0.0f, effects);
    }

    public ChocolateCoinItem(Item.Properties properties, float healing, MobEffectInstance ... effects) {
        super(properties.m_41489_(new FoodProperties.Builder().m_38765_().m_38760_(2).m_38758_(0.1f).m_38767_()));
        this.effects = ImmutableList.copyOf((Object[])effects);
        this.healing = healing;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (level == null) {
            return;
        }
        if (((Boolean)LCConfig.SERVER.chocolateCoinEffects.get()).booleanValue()) {
            if (this.healing > 0.0f) {
                tooltip.add((Component)LCText.TOOLTIP_HEALING.get((int)this.healing).m_130940_(ChatFormatting.BLUE));
            }
            if (!this.effects.isEmpty()) {
                PotionUtils.m_257410_(this.effects, tooltip, (float)1.0f);
            }
        }
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity entity) {
        if (((Boolean)LCConfig.SERVER.chocolateCoinEffects.get()).booleanValue()) {
            if (this.healing > 0.0f) {
                entity.m_5634_(this.healing);
            }
            for (MobEffectInstance effect : this.effects) {
                entity.m_7292_(new MobEffectInstance(effect));
            }
        }
        return super.m_5922_(stack, level, entity);
    }
}

