/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.impl;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.notifications.Notification;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationAPI;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationCategoryType;
import io.github.lightman314.lightmanscurrency.api.notifications.NotificationType;
import io.github.lightman314.lightmanscurrency.common.data.types.NotificationDataCache;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;

public class NotificationAPIImpl
extends NotificationAPI {
    public static NotificationAPI INSTANCE = new NotificationAPIImpl();
    private final Map<String, NotificationType<?>> notificationRegistry = new HashMap();
    private final Map<String, NotificationCategoryType<?>> categoryRegistry = new HashMap();

    private NotificationAPIImpl() {
    }

    @Override
    public void RegisterNotification(@Nonnull NotificationType<?> type) {
        String t = type.type.toString();
        if (this.notificationRegistry.containsKey(t)) {
            LightmansCurrency.LogWarning("Attempted to registerType duplicate NotificationType '" + t + "'!");
            return;
        }
        this.notificationRegistry.put(t, type);
        LightmansCurrency.LogInfo("Registered NotificationType " + type);
    }

    @Override
    public void RegisterCategory(@Nonnull NotificationCategoryType<?> type) {
        String t = type.type.toString();
        if (this.categoryRegistry.containsKey(t)) {
            LightmansCurrency.LogWarning("Attempted to registerType duplicate NotificationCategoryType '" + t + "'!");
            return;
        }
        this.categoryRegistry.put(t, type);
        LightmansCurrency.LogInfo("Registered NotificationCategoryType " + type);
    }

    @Override
    @Nullable
    public Notification LoadNotification(@Nonnull CompoundTag tag) {
        if (tag.m_128441_("Type") || tag.m_128441_("type")) {
            String type;
            String string = type = tag.m_128441_("Type") ? tag.m_128461_("Type") : tag.m_128461_("type");
            if (this.notificationRegistry.containsKey(type)) {
                try {
                    return this.notificationRegistry.get(type).load(tag);
                }
                catch (Throwable t) {
                    LightmansCurrency.LogError("Error loading Notification of type '" + type + "'", t);
                    return null;
                }
            }
            LightmansCurrency.LogError("Cannot load notification type " + type + " as no NotificationType has been registered with that name");
            return null;
        }
        LightmansCurrency.LogError("Cannot deserialize notification as tag is missing the 'type' tag");
        return null;
    }

    @Override
    @Nullable
    public NotificationCategory LoadCategory(@Nonnull CompoundTag tag) {
        if (tag.m_128441_("Type") || tag.m_128441_("type")) {
            String type;
            String string = type = tag.m_128441_("Type") ? tag.m_128461_("Type") : tag.m_128461_("type");
            if (this.categoryRegistry.containsKey(type)) {
                return this.categoryRegistry.get(type).load(tag);
            }
            LightmansCurrency.LogError("Cannot load notification category type " + type + " as no NotificationCategoryType has been registered.");
            return null;
        }
        LightmansCurrency.LogError("Cannot deserialize notification category as tag is missing the 'type' tag.");
        return null;
    }

    @Override
    public void PushPlayerNotification(@Nonnull UUID playerID, @Nonnull Notification notification, boolean pushToChat) {
        NotificationDataCache.TYPE.get(false).pushNotification(playerID, notification, pushToChat);
    }
}

