/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.impl;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.capability.money.MoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.types.CurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.types.IPlayerMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.common.impl.PlayerMoneyHolder;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class MoneyAPIImpl
extends MoneyAPI {
    public static final MoneyAPI INSTANCE = new MoneyAPIImpl();
    private final Map<ResourceLocation, CurrencyType> registeredCurrencyTypes = new HashMap<ResourceLocation, CurrencyType>();
    private final Map<UUID, PlayerMoneyHolder> clientPlayerCache = new HashMap<UUID, PlayerMoneyHolder>();
    private final Map<UUID, PlayerMoneyHolder> serverPlayerCache = new HashMap<UUID, PlayerMoneyHolder>();

    private MoneyAPIImpl() {
    }

    @Override
    public List<CurrencyType> AllCurrencyTypes() {
        return ImmutableList.copyOf(this.registeredCurrencyTypes.values());
    }

    @Override
    @Nullable
    public CurrencyType GetRegisteredCurrencyType(ResourceLocation id) {
        return this.registeredCurrencyTypes.get(id);
    }

    @Override
    public void RegisterCurrencyType(CurrencyType type) {
        if (this.registeredCurrencyTypes.containsKey(type.getType())) {
            CurrencyType existingType = this.registeredCurrencyTypes.get(type.getType());
            if (existingType == type) {
                LightmansCurrency.LogWarning("Money Type " + type.getType() + " was registered twice!");
            } else {
                LightmansCurrency.LogError("Tried to register Money Type " + type.getType() + ", but another type has already been registered under that id!");
            }
            return;
        }
        this.registeredCurrencyTypes.put(type.getType(), type);
        LightmansCurrency.LogDebug("Registered Currency Type: " + type.getType());
    }

    @Override
    public IMoneyHolder GetPlayersMoneyHandler(Player player) {
        Map<UUID, PlayerMoneyHolder> cache;
        Map<UUID, PlayerMoneyHolder> map = cache = player.m_7578_() ? this.clientPlayerCache : this.serverPlayerCache;
        if (!cache.containsKey(player.m_20148_())) {
            ArrayList<IPlayerMoneyHandler> handlers = new ArrayList<IPlayerMoneyHandler>();
            for (CurrencyType type : this.registeredCurrencyTypes.values()) {
                IPlayerMoneyHandler h = type.createMoneyHandlerForPlayer(player);
                if (h == null) continue;
                handlers.add(h);
            }
            cache.put(player.m_20148_(), new PlayerMoneyHolder(handlers));
        }
        return cache.get(player.m_20148_()).updatePlayer(player);
    }

    @Override
    protected IMoneyHandler CreateContainersMoneyHandler(Container container, Consumer<ItemStack> overflowHandler, IClientTracker tracker) {
        ArrayList<IMoneyHandler> handlers = new ArrayList<IMoneyHandler>();
        for (CurrencyType type : this.registeredCurrencyTypes.values()) {
            IMoneyHandler h = type.createMoneyHandlerForContainer(container, overflowHandler, tracker);
            if (h == null) continue;
            handlers.add(h);
        }
        return MoneyHandler.combine(handlers);
    }

    @Override
    public IMoneyHandler GetATMMoneyHandler(Player player, Container container) {
        ArrayList<IMoneyHandler> handlers = new ArrayList<IMoneyHandler>();
        for (CurrencyType type : this.registeredCurrencyTypes.values()) {
            IMoneyHandler h = type.createMoneyHandlerForATM(player, container);
            if (h == null) continue;
            handlers.add(h);
        }
        return MoneyHandler.combine(handlers);
    }

    @Override
    public boolean ItemAllowedInMoneySlot(Player player, ItemStack stack) {
        for (CurrencyType type : this.registeredCurrencyTypes.values()) {
            if (!type.allowItemInMoneySlot(player, stack)) continue;
            return true;
        }
        return false;
    }
}

