/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands.arguments;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.types.CurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValueParser;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MoneyValueArgument
implements ArgumentType<MoneyValue> {
    private final HolderLookup<Item> items;

    private MoneyValueArgument(HolderLookup<Item> items) {
        this.items = items;
    }

    public static MoneyValueArgument argument(CommandBuildContext context) {
        return new MoneyValueArgument((HolderLookup<Item>)context.m_227133_(ForgeRegistries.ITEMS.getRegistryKey()));
    }

    public static MoneyValueArgument safeArgument(RegisterCommandsEvent event) {
        return MoneyValueArgument.argument(event.getBuildContext());
    }

    public static MoneyValue getMoneyValue(CommandContext<CommandSourceStack> commandContext, String name) throws CommandSyntaxException {
        return (MoneyValue)commandContext.getArgument(name, CoinValue.class);
    }

    public MoneyValue parse(StringReader reader) throws CommandSyntaxException {
        return MoneyValueParser.parse(reader, false);
    }

    @Nonnull
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String arg = builder.getRemaining();
        if (arg.contains(";")) {
            String[] split = arg.split(";", 2);
            String prefix = split[0];
            String trail = split.length > 1 ? split[1] : "";
            for (CurrencyType type : MoneyAPI.API.AllCurrencyTypes()) {
                MoneyValueParser parser = type.getValueParser();
                if (parser == null || !parser.prefix.equals(prefix)) continue;
                return parser.listSuggestions(context, builder, trail, this.items);
            }
            return Suggestions.empty();
        }
        for (CurrencyType type : MoneyAPI.API.AllCurrencyTypes()) {
            MoneyValueParser parser = type.getValueParser();
            if (parser == null || !parser.prefix.startsWith(builder.getRemainingLowerCase())) continue;
            builder.suggest(parser.prefix + ";");
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        ArrayList<String> examples = new ArrayList<String>();
        for (CurrencyType type : MoneyAPI.API.AllCurrencyTypes()) {
            MoneyValueParser parser = type.getValueParser();
            if (parser == null) continue;
            parser.addExamples(examples);
        }
        return ImmutableList.copyOf(examples);
    }
}

