/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.capability.wallet;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.capability.money.MoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.coins.CoinAPI;
import io.github.lightman314.lightmanscurrency.api.money.types.builtin.CoinCurrencyType;
import io.github.lightman314.lightmanscurrency.api.money.types.builtin.coins.CoinContainerMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.builtin.CoinValue;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenu;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemHandlerHelper;

public class WalletHandler
extends MoneyHandler
implements IWalletHandler {
    final LivingEntity entity;
    ItemStack walletItem;
    ItemStack backupWallet;
    boolean visible;
    boolean wasVisible;

    @Override
    public boolean isClient() {
        return this.entity.m_9236_().f_46443_;
    }

    public WalletHandler(LivingEntity entity) {
        this.entity = entity;
        this.backupWallet = ItemStack.f_41583_;
        this.walletItem = ItemStack.f_41583_;
        this.visible = true;
        this.wasVisible = true;
    }

    private void handleOverflow(@Nonnull ItemStack overflow) {
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)overflow);
        } else {
            LazyOptional optional = this.entity.getCapability(ForgeCapabilities.ITEM_HANDLER);
            AtomicReference<ItemStack> reference = new AtomicReference<ItemStack>(overflow);
            optional.ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots() && !((ItemStack)reference.get()).m_41619_(); ++i) {
                    reference.set(handler.insertItem(i, (ItemStack)reference.get(), false));
                }
            });
            if (!reference.get().m_41619_()) {
                InventoryUtil.dumpContents(this.entity.m_9236_(), this.entity.m_20183_(), reference.get());
            }
        }
    }

    @Nullable
    private Container getWalletContainer() {
        ItemStack w = this.getWallet();
        if (WalletItem.isWallet(w)) {
            return WalletItem.getWalletInventory(w);
        }
        return null;
    }

    @Override
    public ItemStack getWallet() {
        if (LCCurios.isLoaded()) {
            return LCCurios.getCuriosWalletItem(this.entity);
        }
        return this.walletItem;
    }

    @Override
    public ItemStack getVisibleWallet() {
        if (LCCurios.isLoaded()) {
            return LCCurios.getVisibleCuriosWalletItem(this.entity);
        }
        return this.walletItem;
    }

    @Override
    public void setWallet(ItemStack walletStack) {
        if (LCCurios.hasWalletSlot(this.entity)) {
            LCCurios.setCuriosWalletItem(this.entity, walletStack);
            return;
        }
        this.walletItem = walletStack;
        if (!(walletStack.m_41720_() instanceof WalletItem) && !walletStack.m_41619_()) {
            LightmansCurrency.LogWarning("Equipped a non-wallet to the players wallet slot.");
        }
    }

    @Override
    public void syncWallet(ItemStack walletStack) {
        this.walletItem = walletStack;
    }

    @Override
    public boolean visible() {
        if (LCCurios.hasWalletSlot(this.entity)) {
            return LCCurios.getCuriosWalletVisibility(this.entity);
        }
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public LivingEntity entity() {
        return this.entity;
    }

    @Override
    public boolean isDirty() {
        return !InventoryUtil.ItemsFullyMatch(this.backupWallet, this.getWallet()) || this.wasVisible != this.visible;
    }

    @Override
    public void clean() {
        this.backupWallet = this.walletItem.m_41777_();
        this.wasVisible = this.visible;
    }

    @Override
    public CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        CompoundTag walletItem = this.walletItem.m_41739_(new CompoundTag());
        compound.m_128365_("Wallet", (Tag)walletItem);
        compound.m_128379_("Visible", this.visible);
        return compound;
    }

    @Override
    public void load(CompoundTag compound) {
        this.walletItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Wallet"));
        if (compound.m_128441_("Visible")) {
            this.visible = compound.m_128471_("Visible");
        }
        this.clean();
    }

    @Override
    public void tick() {
        if (!this.walletItem.m_41619_() && LCCurios.hasWalletSlot(this.entity)) {
            LightmansCurrency.LogInfo("Curios detected. Moving wallet from Lightman's Currency wallet slot into the curios wallet slot.");
            LCCurios.setCuriosWalletItem(this.entity, this.walletItem);
            this.walletItem = ItemStack.f_41583_;
        }
    }

    @Override
    @Nonnull
    public MoneyValue insertMoney(@Nonnull MoneyValue insertAmount, boolean simulation) {
        Container container = this.getWalletContainer();
        if (container != null) {
            Container cache = InventoryUtil.copyInventory(container);
            IMoneyHandler handler = CoinCurrencyType.INSTANCE.createMoneyHandlerForContainer(container, this::handleOverflow, this);
            MoneyValue result = handler.insertMoney(insertAmount, simulation);
            if (!InventoryUtil.ContainerMatches(container, cache)) {
                this.updateWalletContents(container);
            }
            return result;
        }
        if (insertAmount instanceof CoinValue) {
            CoinValue coinValue = (CoinValue)insertAmount;
            if (!simulation) {
                for (ItemStack stack : coinValue.getAsSeperatedItemList()) {
                    this.handleOverflow(stack);
                }
            }
            return MoneyValue.empty();
        }
        return insertAmount;
    }

    @Override
    @Nonnull
    public MoneyValue extractMoney(@Nonnull MoneyValue extractAmount, boolean simulation) {
        Container container = this.getWalletContainer();
        if (container != null) {
            Container cache = InventoryUtil.copyInventory(container);
            IMoneyHandler handler = CoinCurrencyType.INSTANCE.createMoneyHandlerForContainer(container, this::handleOverflow, this);
            MoneyValue result = handler.extractMoney(extractAmount, simulation);
            if (!InventoryUtil.ContainerMatches(container, cache)) {
                this.updateWalletContents(container);
            }
            return result;
        }
        return extractAmount;
    }

    private void updateWalletContents(@Nonnull Container updatedContainer) {
        ItemStack w = this.getWallet();
        if (WalletItem.getAutoExchange(w)) {
            CoinAPI.API.CoinExchangeAllUp(updatedContainer);
            CoinAPI.API.SortCoinsByValue(updatedContainer);
        }
        WalletItem.putWalletInventory(w, updatedContainer);
        WalletMenu.OnWalletUpdated((Entity)this.entity);
    }

    @Override
    public boolean isMoneyTypeValid(@Nonnull MoneyValue value) {
        if (WalletItem.isWallet(this.getWallet())) {
            return value instanceof CoinValue;
        }
        return false;
    }

    @Override
    protected void collectStoredMoney(@Nonnull MoneyView.Builder builder) {
        ItemStack wallet = this.getWallet();
        if (WalletItem.isWallet(wallet)) {
            CoinContainerMoneyHandler.queryContainerContents((Container)WalletItem.getWalletInventory(wallet), builder);
        }
    }
}

