/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.VariantProperties;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.properties.builtin.TooltipInfo;
import io.github.lightman314.lightmanscurrency.common.blockentity.variant.IVariantSupportingBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.variant.IVariantBlock;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EasyBlock
extends Block {
    public EasyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        EasyBlock easyBlock = this;
        if (easyBlock instanceof IVariantBlock) {
            IVariantBlock vb = (IVariantBlock)((Object)easyBlock);
            this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)IVariantBlock.VARIANT, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        if (this instanceof IVariantBlock) {
            builder.m_61104_(new Property[]{IVariantBlock.VARIANT});
        }
    }

    protected boolean isBlockOpaque(BlockState state) {
        return this.isBlockOpaque();
    }

    protected boolean isBlockOpaque() {
        return true;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        if (this instanceof IVariantBlock && ((Boolean)state.m_61143_((Property)IVariantBlock.VARIANT)).booleanValue()) {
            return Shapes.m_83040_();
        }
        if (this.isBlockOpaque(state)) {
            return super.m_7952_(state, level, pos);
        }
        return Shapes.m_83040_();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        EasyBlock easyBlock;
        ItemStack result = super.getCloneItemStack(state, target, level, pos, player);
        if (player.m_6047_() && (easyBlock = this) instanceof IVariantBlock) {
            IVariantBlock vb = (IVariantBlock)((Object)easyBlock);
            easyBlock = level.m_7702_(pos);
            if (easyBlock instanceof IVariantSupportingBlockEntity) {
                IVariantSupportingBlockEntity be = (IVariantSupportingBlockEntity)((Object)easyBlock);
                IVariantSupportingBlockEntity.copyDataToItem(be, result);
            }
        }
        return result;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter context, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag;
        EasyBlock easyBlock = this;
        if (easyBlock instanceof IVariantBlock) {
            IVariantBlock block = (IVariantBlock)((Object)easyBlock);
            ResourceLocation variantID = IVariantBlock.getItemVariant(stack);
            if (variantID != null) {
                ModelVariant variant = ModelVariantDataManager.getVariant(variantID);
                if (variant != null) {
                    tooltip.add((Component)LCText.TOOLTIP_MODEL_VARIANT_NAME.get(variant.getName().m_130940_(ChatFormatting.GOLD)).m_130940_(ChatFormatting.YELLOW));
                    if (variant.has(VariantProperties.TOOLTIP_INFO)) {
                        TooltipInfo extraTooltip = variant.get(VariantProperties.TOOLTIP_INFO);
                        if (extraTooltip.drawOnItem) {
                            tooltip.addAll(extraTooltip.getTooltip());
                        }
                    }
                }
                if (flag.m_7050_()) {
                    tooltip.add((Component)LCText.TOOLTIP_MODEL_VARIANT_ID.get(variantID.toString()).m_130940_(ChatFormatting.DARK_GRAY));
                }
            }
        }
        if ((tag = stack.m_41783_()) != null && tag.m_128471_("VariantLocked")) {
            tooltip.add((Component)LCText.TOOLTIP_MODEL_VARIANT_LOCKED.getWithStyle(ChatFormatting.GRAY));
        }
        super.m_5871_(stack, context, tooltip, flag);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryCopyVariant(level, pos, stack);
    }

    protected final void tryCopyVariant(Level level, BlockPos pos, ItemStack stack) {
        BlockEntity blockEntity;
        if (level.f_46443_) {
            return;
        }
        if (this instanceof IVariantBlock && (blockEntity = level.m_7702_(pos)) instanceof IVariantSupportingBlockEntity) {
            IVariantSupportingBlockEntity be = (IVariantSupportingBlockEntity)blockEntity;
            be.setVariant(IVariantBlock.getItemVariant(stack));
            ((BlockEntity)be).onLoad();
        }
    }
}

