/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.util;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IPreRender;
import io.github.lightman314.lightmanscurrency.client.gui.util.IWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.IRotatableWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.WidgetRotation;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LazyWidgetPositioner
implements IPreRender,
IWidgetPositioner {
    @Deprecated
    public static final ISimplePositionerMode MODE_TOPDOWN = positioner -> positioner.startPos().offset(0, positioner.widgetSize * positioner.getPositionIndex());
    @Deprecated
    public static final ISimplePositionerMode MODE_BOTTOMUP = positioner -> positioner.startPos().offset(0, -positioner.widgetSize * positioner.getPositionIndex());
    private final IEasyScreen screen;
    private final IPositionerMode mode;
    private final List<EasyWidget> widgetList = new ArrayList<EasyWidget>();
    private final ScreenPosition offset;
    public final int widgetSize;
    private int posIndex;

    @Nonnull
    public static IPositionerMode createClockwiseWraparound(@Nonnull ScreenArea edges, @Nonnull WidgetRotation startingEdge) {
        return new WraparoundMode(edges, startingEdge, true);
    }

    @Nonnull
    public static IPositionerMode createCounterClockwiseWraparound(@Nonnull ScreenArea edges, @Nonnull WidgetRotation startingEdge) {
        return new WraparoundMode(edges, startingEdge, false);
    }

    public static IPositionerMode createTopdown() {
        return LazyWidgetPositioner.createTopdown(null);
    }

    public static IPositionerMode createTopdown(@Nullable WidgetRotation rotation) {
        return new StraightMode(0, 1, rotation);
    }

    public static IPositionerMode createBottomup() {
        return LazyWidgetPositioner.createBottomup(null);
    }

    public static IPositionerMode createBottomup(@Nullable WidgetRotation rotation) {
        return new StraightMode(0, -1, rotation);
    }

    public static IPositionerMode createLeftRight() {
        return LazyWidgetPositioner.createLeftRight(null);
    }

    public static IPositionerMode createLeftRight(@Nullable WidgetRotation rotation) {
        return new StraightMode(1, 0, rotation);
    }

    public static IPositionerMode createRightLeft() {
        return LazyWidgetPositioner.createRightLeft(null);
    }

    public static IPositionerMode createRightLeft(@Nullable WidgetRotation rotation) {
        return new StraightMode(-1, 0, rotation);
    }

    public final ScreenPosition startPos() {
        return this.screen.getCorner().offset(this.offset);
    }

    public int getPositionIndex() {
        return this.posIndex;
    }

    public static LazyWidgetPositioner create(IEasyScreen screen, IPositionerMode mode, int widgetSize) {
        return new LazyWidgetPositioner(screen, mode, ScreenPosition.ZERO, widgetSize);
    }

    public static LazyWidgetPositioner create(IEasyScreen screen, IPositionerMode mode, ScreenPosition offset, int widgetSize) {
        return new LazyWidgetPositioner(screen, mode, offset, widgetSize);
    }

    public static LazyWidgetPositioner create(IEasyScreen screen, IPositionerMode mode, int x1, int y1, int widgetSize) {
        return new LazyWidgetPositioner(screen, mode, ScreenPosition.of(x1, y1), widgetSize);
    }

    private LazyWidgetPositioner(IEasyScreen screen, IPositionerMode mode, ScreenPosition offset, int widgetSize) {
        this.screen = Objects.requireNonNull(screen);
        this.mode = Objects.requireNonNull(mode);
        this.offset = offset;
        this.widgetSize = widgetSize;
    }

    @Override
    public void addWidget(@Nonnull EasyWidget widget) {
        if (widget != null && !this.widgetList.contains((Object)widget)) {
            this.widgetList.add(widget);
        }
    }

    @Override
    public void removeWidget(@Nonnull EasyWidget widget) {
        if (widget != null) {
            this.widgetList.remove((Object)widget);
        }
    }

    @Override
    public void preRender(@Nonnull EasyGuiGraphics gui) {
        this.posIndex = 0;
        for (EasyWidget w : this.widgetList) {
            if (!w.isVisible()) continue;
            this.mode.moveWidget(this, w);
            ++this.posIndex;
        }
    }

    @Override
    public void clear() {
        this.widgetList.clear();
    }

    private static class WraparoundMode
    implements IPositionerMode {
        private final ScreenArea area;
        private final WidgetRotation startingEdge;
        private final boolean clockwise;

        private WraparoundMode(@Nonnull ScreenArea area, WidgetRotation startingEdge, boolean clockwise) {
            this.area = area;
            this.startingEdge = startingEdge;
            this.clockwise = clockwise;
        }

        @Override
        public void moveWidget(@Nonnull LazyWidgetPositioner positioner, @Nonnull EasyWidget widget) {
            Pair<WidgetRotation, Integer> edgeAndSlot = this.edgeAndPosForSlot(positioner.widgetSize, positioner.getPositionIndex());
            WidgetRotation edge = (WidgetRotation)((Object)edgeAndSlot.getFirst());
            int slot = (Integer)edgeAndSlot.getSecond();
            ScreenPosition startPos = this.startPosForEdge(edge, positioner.widgetSize);
            int xOffPer = this.isHorizEdge(edge) ? 0 : positioner.widgetSize;
            int yOffPer = this.isHorizEdge(edge) ? positioner.widgetSize : 0;
            int mult = this.moveMultForEdge(edge);
            widget.setPosition(startPos.offset(xOffPer * mult * slot, yOffPer * mult * slot));
            if (widget instanceof IRotatableWidget) {
                IRotatableWidget rw = (IRotatableWidget)((Object)widget);
                rw.setRotation(edge);
            }
        }

        private int countForHorizEdge(int widgetSize) {
            return this.area.height / widgetSize;
        }

        private int countForVertEdge(int widgetSize) {
            return this.area.width / widgetSize;
        }

        private Pair<WidgetRotation, Integer> edgeAndPosForSlot(int widgetSize, int slot) {
            int horizLimit = this.countForHorizEdge(widgetSize);
            int vertLimit = this.countForVertEdge(widgetSize);
            WidgetRotation edge = this.startingEdge;
            while (true) {
                if (this.isHorizEdge(edge)) {
                    if (slot < horizLimit) {
                        return Pair.of((Object)((Object)edge), (Object)slot);
                    }
                    slot -= horizLimit;
                } else {
                    if (slot < vertLimit) {
                        return Pair.of((Object)((Object)edge), (Object)slot);
                    }
                    slot -= vertLimit;
                }
                edge = this.nextEdge(edge);
            }
        }

        private WidgetRotation nextEdge(WidgetRotation edge) {
            return this.clockwise ? edge.clockwise() : edge.counterClockwise();
        }

        private boolean isHorizEdge(WidgetRotation edge) {
            return edge == WidgetRotation.LEFT || edge == WidgetRotation.RIGHT;
        }

        private ScreenPosition startPosForEdge(WidgetRotation edge, int widgetSize) {
            return switch (edge) {
                default -> throw new IncompatibleClassChangeError();
                case WidgetRotation.TOP -> {
                    if (this.clockwise) {
                        yield this.area.pos.offset(0, -widgetSize);
                    }
                    yield this.area.pos.offset(this.area.width - widgetSize, -widgetSize);
                }
                case WidgetRotation.RIGHT -> {
                    if (this.clockwise) {
                        yield this.area.pos.offset(this.area.width, 0);
                    }
                    yield this.area.pos.offset(this.area.width, this.area.height - widgetSize);
                }
                case WidgetRotation.BOTTOM -> {
                    if (this.clockwise) {
                        yield this.area.pos.offset(this.area.width - widgetSize, this.area.height);
                    }
                    yield this.area.pos.offset(0, this.area.height);
                }
                case WidgetRotation.LEFT -> this.clockwise ? this.area.pos.offset(-widgetSize, this.area.height - widgetSize) : this.area.pos.offset(-widgetSize, 0);
            };
        }

        private int moveMultForEdge(WidgetRotation edge) {
            return switch (edge) {
                default -> throw new IncompatibleClassChangeError();
                case WidgetRotation.TOP, WidgetRotation.RIGHT -> {
                    if (this.clockwise) {
                        yield 1;
                    }
                    yield -1;
                }
                case WidgetRotation.BOTTOM, WidgetRotation.LEFT -> this.clockwise ? -1 : 1;
            };
        }
    }

    public static interface IPositionerMode {
        public void moveWidget(@Nonnull LazyWidgetPositioner var1, @Nonnull EasyWidget var2);

        @Nonnull
        default public IPositionerMode andThen(@Nonnull Consumer<EasyWidget> action) {
            return this.andThen((LazyWidgetPositioner p, EasyWidget w) -> action.accept((EasyWidget)((Object)w)));
        }

        default public IPositionerMode andThen(@Nonnull BiConsumer<LazyWidgetPositioner, EasyWidget> action) {
            return new CombinedMode(this, action);
        }
    }

    private static class StraightMode
    implements IPositionerMode {
        private final int xMult;
        private final int yMult;
        private final WidgetRotation rotation;

        StraightMode(int xMult, int yMult, @Nullable WidgetRotation rotation) {
            this.xMult = xMult;
            this.yMult = yMult;
            this.rotation = rotation;
        }

        @Override
        public void moveWidget(@Nonnull LazyWidgetPositioner positioner, @Nonnull EasyWidget widget) {
            widget.setPosition(positioner.startPos().offset(positioner.widgetSize * this.xMult * positioner.getPositionIndex(), positioner.widgetSize * this.yMult * positioner.getPositionIndex()));
            if (this.rotation != null && widget instanceof IRotatableWidget) {
                IRotatableWidget w = (IRotatableWidget)((Object)widget);
                w.setRotation(this.rotation);
            }
        }
    }

    @Deprecated
    public static interface ISimplePositionerMode
    extends IPositionerMode {
        @Override
        default public void moveWidget(@Nonnull LazyWidgetPositioner positioner, @Nonnull EasyWidget widget) {
            widget.setPosition(this.getPosition(positioner));
        }

        @Nonnull
        public ScreenPosition getPosition(@Nonnull LazyWidgetPositioner var1);
    }

    private static class CombinedMode
    implements IPositionerMode {
        private final IPositionerMode mode;
        private final BiConsumer<LazyWidgetPositioner, EasyWidget> extraAction;

        CombinedMode(@Nonnull IPositionerMode mode, @Nonnull BiConsumer<LazyWidgetPositioner, EasyWidget> extraAction) {
            this.mode = mode;
            this.extraAction = extraAction;
        }

        @Override
        public void moveWidget(@Nonnull LazyWidgetPositioner positioner, @Nonnull EasyWidget widget) {
            this.mode.moveWidget(positioner, widget);
            this.extraAction.accept(positioner, widget);
        }
    }
}

