/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.easy;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.WidgetAddon;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.ITooltipSource;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.common.text.MultiLineTextEntry;
import io.github.lightman314.lightmanscurrency.common.text.TextEntry;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class EasyAddonHelper {
    public static WidgetAddon activeCheck(@Nonnull Function<EasyWidget, Boolean> shouldBeActive) {
        return new ActiveCheckAddon(shouldBeActive);
    }

    public static WidgetAddon activeCheck(@Nonnull Supplier<Boolean> shouldBeActive) {
        return new ActiveCheckAddon(b -> (Boolean)shouldBeActive.get());
    }

    public static WidgetAddon visibleCheck(@Nonnull Function<EasyWidget, Boolean> shouldBeVisible) {
        return new VisibleCheckAddon(shouldBeVisible);
    }

    public static WidgetAddon visibleCheck(@Nonnull Supplier<Boolean> shouldBeVisible) {
        return new VisibleCheckAddon(b -> (Boolean)shouldBeVisible.get());
    }

    public static WidgetAddon tooltip(@Nonnull Component tooltip) {
        return new TooltipAddon((Supplier<List<Component>>)Suppliers.memoize(() -> EasyAddonHelper.toList(tooltip)));
    }

    public static WidgetAddon tooltip(@Nonnull TextEntry tooltip) {
        return new TooltipAddon((Supplier<List<Component>>)Suppliers.memoize(() -> EasyAddonHelper.toList((Component)tooltip.get(new Object[0]))));
    }

    public static WidgetAddon tooltip(@Nonnull MultiLineTextEntry tooltip) {
        return new TooltipAddon((Supplier<List<Component>>)Suppliers.memoize(() -> tooltip.get(new Object[0])));
    }

    public static WidgetAddon tooltips(@Nonnull List<Component> tooltip) {
        return new TooltipAddon((Supplier<List<Component>>)Suppliers.memoize(() -> tooltip));
    }

    public static WidgetAddon tooltip(@Nonnull Supplier<Component> tooltip) {
        return new TooltipAddon(() -> EasyAddonHelper.toList((Component)tooltip.get()));
    }

    public static WidgetAddon tooltips(@Nonnull Supplier<List<Component>> tooltip) {
        return new TooltipAddon(tooltip);
    }

    public static WidgetAddon tooltips(@Nonnull Supplier<List<Component>> tooltip, int width) {
        return EasyAddonHelper.tooltips(tooltip, width, false);
    }

    public static WidgetAddon tooltips(@Nonnull Supplier<List<Component>> tooltip, int width, boolean ignoreActive) {
        return new TooltipSplitterAddon(tooltip, width, ignoreActive);
    }

    public static WidgetAddon tooltip(@Nonnull Component tooltip, int width) {
        return EasyAddonHelper.tooltip(tooltip, width, false);
    }

    public static WidgetAddon tooltip(@Nonnull Component tooltip, int width, boolean ignoreActive) {
        return new TooltipSplitterAddon(tooltip, width, ignoreActive);
    }

    public static WidgetAddon tooltip(@Nonnull TextEntry tooltip, int width) {
        return EasyAddonHelper.tooltip(tooltip, width, false);
    }

    public static WidgetAddon tooltip(@Nonnull TextEntry tooltip, int width, boolean ignoreActive) {
        return new TooltipSplitterAddon((Component)tooltip.get(new Object[0]), width, ignoreActive);
    }

    @Deprecated
    public static WidgetAddon additiveTooltip(@Nonnull String translationKey, @Nonnull Supplier<Object[]> inputSource) {
        return EasyAddonHelper.tooltip(() -> Component.m_237110_((String)translationKey, (Object[])((Object[])inputSource.get())));
    }

    @Deprecated
    public static WidgetAddon additiveTooltip2(@Nonnull String translationKey, @Nonnull Supplier<Object> inputSource) {
        return EasyAddonHelper.tooltip(() -> Component.m_237110_((String)translationKey, (Object[])new Object[]{inputSource.get()}));
    }

    public static WidgetAddon toggleTooltip(@Nonnull Supplier<Boolean> toggle, Component trueTooltip, Component falseTooltip) {
        return EasyAddonHelper.tooltip(() -> (Boolean)toggle.get() != false ? trueTooltip : falseTooltip);
    }

    public static WidgetAddon toggleTooltip(@Nonnull Supplier<Boolean> toggle, Supplier<Component> trueTooltip, Supplier<Component> falseTooltip) {
        return EasyAddonHelper.tooltip(() -> (Boolean)toggle.get() != false ? (Component)trueTooltip.get() : (Component)falseTooltip.get());
    }

    public static WidgetAddon changingTooltip(@Nonnull Supplier<Integer> indicator, Component ... tooltips) {
        if (tooltips.length == 0) {
            return EasyAddonHelper.tooltip((Component)EasyText.empty());
        }
        return EasyAddonHelper.tooltip(() -> tooltips[MathUtil.clamp((Integer)indicator.get(), 0, tooltips.length - 1)]);
    }

    private static List<Component> toList(@Nullable Component tooltip) {
        if (tooltip == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)tooltip);
    }

    private static class ActiveCheckAddon
    extends WidgetAddon {
        private final Function<EasyWidget, Boolean> shouldBeActive;

        ActiveCheckAddon(Function<EasyWidget, Boolean> shouldBeActive) {
            this.shouldBeActive = shouldBeActive;
        }

        @Override
        public void activeTick() {
            EasyWidget widget = this.getWidget();
            if (widget != null) {
                widget.setActive(this.shouldBeActive.apply(widget));
            }
        }
    }

    private static class VisibleCheckAddon
    extends WidgetAddon {
        private final Function<EasyWidget, Boolean> shouldBeVisbile;

        VisibleCheckAddon(Function<EasyWidget, Boolean> shouldBeVisbile) {
            this.shouldBeVisbile = shouldBeVisbile;
        }

        @Override
        public void visibleTick() {
            EasyWidget widget = this.getWidget();
            if (widget != null) {
                widget.setVisible(this.shouldBeVisbile.apply(widget));
            }
        }
    }

    private static class TooltipAddon
    extends WidgetAddon
    implements ITooltipSource {
        private final Supplier<List<Component>> tooltip;

        TooltipAddon(@Nonnull Supplier<List<Component>> tooltip) {
            this.tooltip = tooltip;
        }

        @Override
        public List<Component> getTooltipText(int mouseX, int mouseY) {
            EasyWidget w = this.getWidget();
            if (w != null && w.m_142518_() && w.getArea().isMouseInArea(mouseX, mouseY)) {
                return this.tooltip.get();
            }
            return null;
        }
    }

    private static class TooltipSplitterAddon
    extends WidgetAddon
    implements ITooltipSource {
        private final Supplier<List<Component>> tooltip;
        private final int width;
        private final boolean ignoreActive;

        TooltipSplitterAddon(@Nonnull Component tooltip, int width, boolean ignoreActive) {
            this(Lists.newArrayList((Object[])new Component[]{tooltip}), width, ignoreActive);
        }

        TooltipSplitterAddon(@Nonnull List<Component> tooltip, int width, boolean ignoreActive) {
            this(() -> tooltip, width, ignoreActive);
        }

        TooltipSplitterAddon(@Nonnull Supplier<List<Component>> tooltip, int width, boolean ignoreActive) {
            this.tooltip = tooltip;
            this.width = width;
            this.ignoreActive = ignoreActive;
        }

        @Override
        public List<Component> getTooltipText(int mouseX, int mouseY) {
            return null;
        }

        @Override
        public void renderTooltip(EasyGuiGraphics gui) {
            EasyWidget w = this.getWidget();
            if (w != null && (this.ignoreActive || w.m_142518_()) && w.getArea().isMouseInArea(gui.mousePos)) {
                ArrayList<FormattedCharSequence> t = new ArrayList<FormattedCharSequence>();
                List<Component> lines = this.tooltip.get();
                if (lines.isEmpty()) {
                    return;
                }
                for (Component c : lines) {
                    t.addAll(gui.font.m_92923_((FormattedText)c, this.width));
                }
                gui.renderTooltip(t);
            }
        }
    }
}

