/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.wallet;

import io.github.lightman314.lightmanscurrency.client.ClientEvents;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.Sprite;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.InventoryButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.wallet.WalletCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;

public class VisibilityToggleButton
extends InventoryButton {
    public static final int SIZE = 6;
    public static final Sprite SPRITE_VISIBLE = Sprite.SimpleSprite(ClientEvents.WALLET_SLOT_TEXTURE, 34, 0, 6, 6);
    public static final Sprite SPRITE_INVISIBLE = Sprite.SimpleSprite(ClientEvents.WALLET_SLOT_TEXTURE, 28, 0, 6, 6);

    public VisibilityToggleButton(AbstractContainerScreen<?> inventoryScreen, Runnable pressable) {
        super(inventoryScreen, pressable, VisibilityToggleButton::getSprite);
    }

    private static boolean isWalletVisible() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        assert (player != null);
        IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)player);
        return walletHandler != null && walletHandler.visible();
    }

    private static Sprite getSprite() {
        return VisibilityToggleButton.isWalletVisible() ? SPRITE_VISIBLE : SPRITE_INVISIBLE;
    }

    @Override
    protected ScreenPosition getPositionOffset(boolean isCreativeScreen) {
        return ClientEvents.getWalletSlotPosition(isCreativeScreen);
    }
}

