/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TeamButton
extends EasyButton {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/buttons.png");
    public static final int HEIGHT = 20;
    public static final int TEXT_COLOR = 0xFFFFFF;
    private final Supplier<ITeam> teamSource;
    private final Supplier<Boolean> selectedSource;

    public ITeam getTeam() {
        return this.teamSource.get();
    }

    private TeamButton(@Nonnull Builder builder) {
        super(builder);
        this.teamSource = builder.team;
        this.selectedSource = builder.selected;
    }

    @Override
    public void renderWidget(@Nonnull EasyGuiGraphics gui) {
        if (!this.f_93624_ || this.getTeam() == null) {
            return;
        }
        gui.resetColor();
        gui.blitNineSplit(GUI_TEXTURE, 0, 0, this.f_93618_, this.f_93619_, 0, this.selectedSource.get() != false ? 20 : 0, 256, 20, 4);
        gui.drawString(TextRenderUtil.fitString(this.getTeam().getName(), this.f_93618_ - 4), 2, 2, 0xFFFFFF);
        gui.drawString(TextRenderUtil.fitString((Component)LCText.GUI_OWNER_CURRENT.get(this.getTeam().getOwner().getName(true)), this.f_93618_ - 4), 2, 10, 0xFFFFFF);
    }

    @Override
    public void m_7435_(@Nonnull SoundManager soundManager) {
        if (!this.f_93624_ || this.getTeam() == null) {
            return;
        }
        super.m_7435_(soundManager);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder
    extends EasyButton.EasyButtonBuilder<Builder> {
        private Supplier<ITeam> team = () -> null;
        private Supplier<Boolean> selected = () -> false;

        private Builder() {
            super(256, 20);
        }

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder width(int width) {
            this.changeWidth(width);
            return this;
        }

        public Builder team(Supplier<ITeam> team) {
            this.team = team;
            return this;
        }

        public Builder selected(Supplier<Boolean> selected) {
            this.selected = selected;
            return this;
        }

        public TeamButton build() {
            return new TeamButton(this);
        }
    }
}

