/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.slot_machine;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageScreen;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IMouseListener;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.slot_machine.SlotMachineStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SlotMachineStorageClientTab
extends TraderStorageClientTab<SlotMachineStorageTab>
implements IScrollable,
IMouseListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 17;
    private static final int COLUMNS_NORMAL = 8;
    private static final int COLUMNS_PERSISTENT = 10;
    private static final int ROWS = 6;
    int scroll = 0;
    ScrollBarWidget scrollBar;
    int columns = 8;

    public SlotMachineStorageClientTab(Object screen, SlotMachineStorageTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_STORAGE;
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TRADER_STORAGE.get(new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        SlotMachineTraderData trader;
        this.columns = 8;
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof SlotMachineTraderData && (trader = (SlotMachineTraderData)traderData).isPersistent()) {
            this.columns = 10;
        }
        this.scrollBar = this.addChild(((ScrollBarWidget.Builder)ScrollBarWidget.builder().position(screenArea.pos.offset(13 + 18 * this.columns, 17))).height(108).scrollable(this).build());
        this.addChild(((ScrollListener.Builder)((ScrollListener.Builder)ScrollListener.builder().position(screenArea.pos)).size(screenArea.width, 118)).listener(this).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(22, 129))).pressAction(() -> ((SlotMachineStorageTab)this.commonTab).quickTransfer(0))).sprite(IconAndButtonUtil.SPRITE_QUICK_INSERT).addon(EasyAddonHelper.visibleCheck(this::quickButtonsVisible))).build());
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(34, 129))).pressAction(() -> ((SlotMachineStorageTab)this.commonTab).quickTransfer(1))).sprite(IconAndButtonUtil.SPRITE_QUICK_EXTRACT).addon(EasyAddonHelper.visibleCheck(this::quickButtonsVisible))).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.drawString((Component)LCText.TOOLTIP_TRADER_STORAGE.get(new Object[0]), 8, 6, 0x404040);
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            this.validateScroll();
            int index = this.scroll * this.columns;
            TraderItemStorage storage = trader.getStorage();
            int hoverSlot = this.isMouseOverSlot(gui.mousePos) + this.scroll * this.columns;
            for (int y = 0; y < 6; ++y) {
                int n = 17 + y * 18;
                for (int x = 0; x < this.columns; ++x) {
                    int xPos = 13 + x * 18;
                    gui.resetColor();
                    gui.blit(TraderScreen.GUI_TEXTURE, xPos, n, 206, 0, 18, 18);
                    if (index < storage.getSlotCount()) {
                        gui.renderItem(storage.getStackInSlot(index), xPos + 1, n + 1, this.getCountText(storage.getStackInSlot(index)));
                    }
                    if (index == hoverSlot) {
                        gui.renderSlotHighlight(xPos + 1, n + 1);
                    }
                    ++index;
                }
            }
            gui.resetColor();
            for (Slot slot : ((SlotMachineStorageTab)this.commonTab).getSlots()) {
                gui.blit(TraderScreen.GUI_TEXTURE, slot.f_40220_ - 1, slot.f_40221_ - 1, 206, 0, 18, 18);
            }
        }
    }

    private String getCountText(ItemStack stack) {
        int count = stack.m_41613_();
        if (count <= 1) {
            return null;
        }
        if (count >= 1000) {
            Object countText = String.valueOf(count / 1000);
            if (count % 1000 / 100 > 0) {
                countText = (String)countText + "." + count % 1000 / 100;
            }
            return (String)countText + "k";
        }
        return String.valueOf(count);
    }

    @Override
    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            TraderItemStorage storage;
            int hoveredSlot;
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            if (((ITraderStorageScreen)this.screen).getMenu().getHeldItem().m_41619_() && (hoveredSlot = this.isMouseOverSlot(gui.mousePos)) >= 0 && (hoveredSlot += this.scroll * this.columns) < (storage = trader.getStorage()).getContents().size()) {
                ItemStack stack = storage.getContents().get(hoveredSlot);
                if (stack.m_41619_()) {
                    return;
                }
                EasyScreenHelper.RenderItemTooltipWithCount(gui, stack, storage.getMaxAmount(), ChatFormatting.YELLOW);
            }
        }
    }

    private int isMouseOverSlot(ScreenPosition mousePos) {
        int foundColumn = -1;
        int foundRow = -1;
        int leftEdge = ((ITraderStorageScreen)this.screen).getGuiLeft() + 13;
        int topEdge = ((ITraderStorageScreen)this.screen).getGuiTop() + 17;
        for (int x = 0; x < this.columns && foundColumn < 0; ++x) {
            if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
            foundColumn = x;
        }
        for (int y = 0; y < 6 && foundRow < 0; ++y) {
            if (mousePos.y < topEdge + y * 18 || mousePos.y >= topEdge + y * 18 + 18) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * this.columns + foundColumn;
    }

    private int totalStorageSlots() {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            return trader.getStorage().getContents().size();
        }
        return 0;
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        int hoveredSlot;
        if (((ITraderStorageMenu)this.menu).getTrader() instanceof SlotMachineTraderData && (hoveredSlot = this.isMouseOverSlot(ScreenPosition.of(mouseX, mouseY))) >= 0) {
            ((SlotMachineStorageTab)this.commonTab).clickedOnSlot(hoveredSlot += this.scroll * this.columns, Screen.m_96638_(), button == 0);
            return true;
        }
        return false;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.totalStorageSlots() - 1) / this.columns - 6 + 1, 0);
    }

    private boolean quickButtonsVisible() {
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        return trader instanceof SlotMachineTraderData && !trader.isPersistent();
    }

    @Override
    @Nullable
    public Pair<ItemStack, ScreenArea> getHoveredItem(@Nonnull ScreenPosition mousePos) {
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            int foundColumn = -1;
            int foundRow = -1;
            int leftEdge = ((ITraderStorageScreen)this.screen).getGuiLeft() + 13;
            int topEdge = ((ITraderStorageScreen)this.screen).getGuiTop() + 17;
            for (int x = 0; x < this.columns && foundColumn < 0; ++x) {
                if (mousePos.x < leftEdge + x * 18 || mousePos.x >= leftEdge + x * 18 + 18) continue;
                foundColumn = x;
            }
            for (int y = 0; y < 6 && foundRow < 0; ++y) {
                if (mousePos.y < topEdge + y * 18 || mousePos.y >= topEdge + y * 18 + 18) continue;
                foundRow = y;
            }
            if (foundColumn < 0 || foundRow < 0) {
                return null;
            }
            int slot = foundRow * this.columns + foundColumn + this.scroll * this.columns;
            ItemStack stack = trader.getStorage().getStackInSlot(slot);
            return Pair.of((Object)stack, (Object)ScreenArea.of(leftEdge + foundColumn * 18, topEdge + foundRow * 18, 18, 18));
        }
        return null;
    }
}

