/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.slot_machine;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.input.MoneyValueWidget;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.slot_machine.SlotMachinePriceTab;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;

public class SlotMachinePriceClientTab
extends TraderStorageClientTab<SlotMachinePriceTab> {
    private MoneyValueWidget priceInput;

    public SlotMachinePriceClientTab(Object screen, SlotMachinePriceTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of(ModItems.COIN_GOLD);
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TRADER_SLOT_MACHINE_EDIT_PRICE.get(new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        MoneyValue startingPrice = MoneyValue.empty();
        TraderData traderData = ((ITraderStorageMenu)this.menu).getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            startingPrice = trader.getPrice();
        }
        this.priceInput = this.addChild(((MoneyValueWidget.Builder)MoneyValueWidget.builder().position(screenArea.pos.offset(screenArea.width / 2 - 88, 12))).oldIfNotFirst(firstOpen, this.priceInput).startingValue(startingPrice).valueHandler(this::ChangePrice).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
    }

    private void ChangePrice(MoneyValue newPrice) {
        ((SlotMachinePriceTab)this.commonTab).SetPrice(newPrice);
    }
}

