/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.SmallTabButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.WidgetRotation;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.LazyWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.TraderSettingsTab;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;

public class TraderSettingsClientTab
extends TraderStorageClientTab<TraderSettingsTab> {
    private int selectedTab = 0;
    private final List<SettingsSubTab> tabs = new ArrayList<SettingsSubTab>();

    private SettingsSubTab getCurrentTab() {
        if (this.selectedTab < 0 || this.selectedTab >= this.tabs.size()) {
            this.selectedTab = 0;
        }
        if (!this.tabs.isEmpty()) {
            return this.tabs.get(this.selectedTab);
        }
        return null;
    }

    public TraderSettingsClientTab(Object screen, TraderSettingsTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_SETTINGS;
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TRADER_SETTINGS.get(new Object[0]);
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        LazyWidgetPositioner tabPositioner = this.addChild(LazyWidgetPositioner.create(this.screen, LazyWidgetPositioner.createClockwiseWraparound(screenArea, WidgetRotation.RIGHT), 20));
        if (firstOpen) {
            this.selectedTab = 0;
        }
        this.tabs.clear();
        TraderData trader = ((ITraderStorageMenu)this.menu).getTrader();
        if (trader != null) {
            this.tabs.addAll(trader.getSettingsTabs(this));
        }
        for (int i = 0; i < this.tabs.size(); ++i) {
            int tabIndex = i;
            SettingsSubTab tab = this.tabs.get(i);
            SmallTabButton newButton = this.addChild(((SmallTabButton.Builder)((SmallTabButton.Builder)((SmallTabButton.Builder)SmallTabButton.builder().pressAction(() -> this.openTab(tabIndex))).tab(tab).addon(EasyAddonHelper.visibleCheck(tab::canOpen))).addon(EasyAddonHelper.activeCheck(() -> this.selectedTab != tabIndex))).build());
            tabPositioner.addWidget(newButton);
        }
        this.getCurrentTab().onOpen();
        this.tick();
    }

    public void openTab(int index) {
        if (index == this.selectedTab || index < 0 || index >= this.tabs.size()) {
            return;
        }
        this.getCurrentTab().onClose();
        this.selectedTab = index;
        this.getCurrentTab().onOpen();
    }

    @Override
    public void tick() {
        if (!this.getCurrentTab().canOpen() && this.selectedTab != 0) {
            this.openTab(0);
        }
        this.getCurrentTab().tick();
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        this.getCurrentTab().renderBG(gui);
    }

    @Override
    public void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        this.getCurrentTab().renderAfterWidgets(gui);
    }

    @Override
    public boolean shouldRenderInventoryText() {
        return this.getCurrentTab().shouldRenderInventoryText();
    }

    @Override
    public boolean showRightEdgeButtons() {
        return false;
    }
}

