/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.QuarantineAPI;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.interfaces.IEasyScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.LazyWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenu;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketOpenWalletBank;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketWalletExchangeCoins;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketWalletQuickCollect;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketWalletToggleAutoExchange;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WalletScreen
extends EasyMenuScreen<WalletMenu> {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/container/wallet.png");
    IconButton buttonToggleAutoExchange;
    EasyButton buttonExchange;
    EasyButton buttonOpenBank;
    EasyButton buttonQuickCollect;
    private final LazyWidgetPositioner positioner = LazyWidgetPositioner.create(this, LazyWidgetPositioner.createTopdown(), -20, 0, 20);

    public WalletScreen(WalletMenu container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        screenArea = this.resize(176 + ((WalletMenu)this.f_97732_).bonusWidth, 114 + ((WalletMenu)this.f_97732_).coinSlotHeight * 18);
        this.buttonExchange = null;
        this.buttonToggleAutoExchange = null;
        this.addChild(this.positioner);
        this.positioner.clear();
        this.buttonExchange = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().pressAction(this::PressExchangeButton)).icon(IconData.of(GUI_TEXTURE, 176, 0)).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_WALLET_EXCHANGE))).addon(EasyAddonHelper.visibleCheck(((WalletMenu)this.f_97732_)::canExchange))).build());
        this.buttonToggleAutoExchange = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().pressAction(this::PressAutoExchangeToggleButton)).icon(this::getAutoExchangeIcon).addon(EasyAddonHelper.tooltip(this::getAutoExchangeTooltip))).addon(EasyAddonHelper.visibleCheck(() -> ((WalletMenu)this.f_97732_).canExchange() && ((WalletMenu)this.f_97732_).canPickup()))).build());
        this.buttonOpenBank = this.addChild(((IconButton.Builder)((IconButton.Builder)((IconButton.Builder)IconButton.builder().pressAction(this::PressOpenBankButton)).icon(IconData.of(ModBlocks.ATM)).addon(EasyAddonHelper.tooltip(LCText.TOOLTIP_WALLET_OPEN_BANK))).addon(EasyAddonHelper.visibleCheck(() -> ((WalletMenu)this.f_97732_).hasBankAccess() && !QuarantineAPI.IsDimensionQuarantined((Entity)((WalletMenu)this.f_97732_).player)))).build());
        this.positioner.addWidgets(this.buttonExchange, this.buttonToggleAutoExchange, this.buttonOpenBank);
        this.buttonQuickCollect = this.addChild(((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(159 + ((WalletMenu)this.f_97732_).halfBonusWidth, screenArea.height - 95))).pressAction(this::PressQuickCollectButton)).sprite(IconAndButtonUtil.SPRITE_QUICK_INSERT).build());
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.resetColor();
        gui.renderNormalBackground(this);
        for (Slot slot : ((WalletMenu)this.f_97732_).f_38839_) {
            gui.renderSlot((IEasyScreen)this, slot);
        }
        gui.drawString(this.getWalletName(), 8, 6, 0x404040);
        gui.drawString(this.f_169604_, 8 + ((WalletMenu)this.f_97732_).halfBonusWidth, this.getYSize() - 94, 0x404040);
    }

    private Component getWalletName() {
        ItemStack wallet = ((WalletMenu)this.f_97732_).getWallet();
        return wallet.m_41619_() ? EasyText.empty() : wallet.m_41786_();
    }

    private IconData getAutoExchangeIcon() {
        return IconData.of(GUI_TEXTURE, 176, ((WalletMenu)this.f_97732_).getAutoExchange() ? 16 : 32);
    }

    private Component getAutoExchangeTooltip() {
        return ((WalletMenu)this.f_97732_).getAutoExchange() ? LCText.TOOLTIP_WALLET_AUTO_EXCHANGE_DISABLE.get(new Object[0]) : LCText.TOOLTIP_WALLET_AUTO_EXCHANGE_ENABLE.get(new Object[0]);
    }

    private void PressExchangeButton(EasyButton button) {
        CPacketWalletExchangeCoins.sendToServer();
    }

    private void PressAutoExchangeToggleButton(EasyButton button) {
        ((WalletMenu)this.f_97732_).ToggleAutoExchange();
        CPacketWalletToggleAutoExchange.sendToServer();
    }

    private void PressOpenBankButton(EasyButton button) {
        new CPacketOpenWalletBank(((WalletMenu)this.f_97732_).getWalletStackIndex()).send();
    }

    private void PressQuickCollectButton(EasyButton button) {
        CPacketWalletQuickCollect.sendToServer();
    }
}

